/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc.props;

import com.cognos.jsmcommon.jdbc.ConnectionException;
import com.cognos.jsmcommon.jdbc.props.DatabaseType;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.property.CMProperties;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public class SybaseProperties
extends JDBCConnectionProperties {
    private String mUrl;
    private String mDriver = "com.sybase.jdbc3.jdbc.SybDriver";
    private final int mFetchSize = 10;
    private final boolean mKeepOpen = false;
    private final DatabaseType mDbType = DatabaseType.SYBASE;
    private final String mCheckConnectionStatement = "select 1 from syslogs";
    private JDBCConnectionProperties.TokenWriter m_token_writer = new SybaseTokenWriter();

    protected SybaseProperties(CMProperties cmProps) throws ConnectionException {
        super(cmProps);
        Properties props = cmProps.getProperties();
        this.mUrl = "jdbc:sybase:Tds:" + props.getProperty("server") + "/" + props.getProperty("name") + "?JCONNECT_VERSION=6&CANCEL_ALL=false&IS_CLOSED_TEST=select 1&BE_AS_JDBC_COMPLIANT_AS_POSSIBLE=true";
        boolean dbEncrypt = Boolean.parseBoolean(props.getProperty("SSLencryptionEnabled"));
        if (dbEncrypt) {
            this.mUrl = this.mUrl + "&SYBSOCKET_FACTORY=com.cognos.cm.dbstore.SybaseSSLSocketFactory";
        }
    }

    @Override
    protected String getDefaultCheckConnectionStatement() {
        return "select 1 from syslogs";
    }

    @Override
    public DatabaseType getDBType() {
        return this.mDbType;
    }

    @Override
    public String getDriverStr() {
        return this.mDriver;
    }

    @Override
    public int getFetchSize() {
        return 10;
    }

    @Override
    public boolean shouldSetFetchSize() {
        return true;
    }

    @Override
    public boolean getKeepOpen() {
        return false;
    }

    @Override
    public String getUrlStr() {
        return this.mUrl;
    }

    @Override
    public int getReadOnlyIsolationLevel() {
        return 2;
    }

    @Override
    public int getReadWriteIsolationLevel() {
        return 2;
    }

    @Override
    public int getMessageTokenLength() {
        return super.getMessageTokenLength() - 4;
    }

    @Override
    public JDBCConnectionProperties.TokenWriter getTokenWriter() {
        return this.m_token_writer;
    }

    public class SybaseTokenWriter
    implements JDBCConnectionProperties.TokenWriter {
        private String prefix = "![";
        private String suffix = "]!";

        @Override
        public String readToken(ResultSet rs, int column) throws SQLException {
            return this.extractToken(rs.getString(column));
        }

        @Override
        public String readToken(ResultSet rs, String column) throws SQLException {
            return this.extractToken(rs.getString(column));
        }

        @Override
        public void writeToken(PreparedStatement ps, int index, String token) throws SQLException {
            token = this.prefix + token + this.suffix;
            ps.setString(index, token);
        }

        private String extractToken(String token) {
            if (token.startsWith(this.prefix) && token.endsWith(this.suffix)) {
                token = token.substring(2, token.length() - 2);
            }
            return token;
        }
    }
}

