/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc.util;

import com.cognos.jsmcommon.jdbc.props.DatabaseType;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.jdbc.util.JDBCBlobUtilGenericImpl;
import com.cognos.jsmcommon.jdbc.util.JDBCBlobUtilOracleImpl;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public abstract class JDBCBlobUtil {
    private static ThreadLocal m_initHolder = new ThreadLocal();
    private static JDBCBlobUtil m_instance = null;
    private static DatabaseType m_dbType = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JDBCBlobUtil getInstance(String component) throws SQLException {
        if (m_initHolder.get() != null) return m_instance;
        Class<JDBCBlobUtil> clazz = JDBCBlobUtil.class;
        synchronized (JDBCBlobUtil.class) {
            if (m_instance == null) {
                m_dbType = JDBCConnectionProperties.instance(component).getDBType();
                m_instance = DatabaseType.ORACLE.equals(m_dbType) ? new JDBCBlobUtilOracleImpl() : new JDBCBlobUtilGenericImpl();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            m_initHolder.set(Boolean.TRUE);
            return m_instance;
        }
    }

    public abstract boolean setBlob(PreparedStatement var1, int var2, byte[] var3) throws SQLException;

    public abstract void updateBlob(PreparedStatement var1, byte[] var2) throws SQLException;

    public boolean mustUpdateBlob() {
        return DatabaseType.ORACLE.equals(m_dbType);
    }
}

