/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc.util;

import com.cognos.jsmcommon.jdbc.util.JDBCBlobUtil;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class JDBCBlobUtilOracleImpl
extends JDBCBlobUtil {
    private Method m_getBytesOutputStream;
    private Object[] m_getBlobParams;
    private Method m_getBLOBMethod;

    public JDBCBlobUtilOracleImpl() throws SQLException {
        ClassLoader oraLoader = this.getClass().getClassLoader();
        if (oraLoader == null && (oraLoader = Thread.currentThread().getContextClassLoader()) == null) {
            oraLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            Class<?> oraResultSetClass = oraLoader.loadClass("oracle.jdbc.internal.OracleResultSet");
            this.m_getBLOBMethod = oraResultSetClass.getMethod("getBLOB", Integer.TYPE);
            Class<?> oraBlobClass = oraLoader.loadClass("oracle.sql.BLOB");
            this.m_getBytesOutputStream = oraBlobClass.getMethod("getBinaryOutputStream", new Class[0]);
            this.m_getBlobParams = new Object[]{new Integer(1)};
        }
        catch (ClassNotFoundException ex) {
            throw new SQLException(ex.getMessage());
        }
        catch (NoSuchMethodException ex) {
            throw new SQLException(ex.getMessage());
        }
    }

    @Override
    public boolean setBlob(PreparedStatement ps, int index, byte[] data) throws SQLException {
        if (data == null) {
            ps.setNull(index, 2004);
        } else {
            ps.setObject(index, new byte[]{1, 1});
        }
        return true;
    }

    @Override
    public void updateBlob(PreparedStatement ps, byte[] data) throws SQLException {
        block11: {
            Object[] noParams = new Object[]{};
            if (data == null || data.length <= 0) {
                return;
            }
            ResultSet rs = null;
            try {
                if (ps == null) break block11;
                rs = ps.executeQuery();
                if (rs != null && rs.next()) {
                    Object blob = this.m_getBLOBMethod.invoke((Object)rs, this.m_getBlobParams);
                    if (blob != null) {
                        OutputStream blobOutputStream = (OutputStream)this.m_getBytesOutputStream.invoke(blob, noParams);
                        blobOutputStream.write(data);
                        blobOutputStream.flush();
                        blobOutputStream.close();
                        break block11;
                    }
                    String errMsg = "the blob field is empty";
                    throw new SQLException(errMsg);
                }
                throw new SQLException("Error : the blob query returned 0 rows");
            }
            catch (IOException ex) {
                throw new SQLException("Error : could not update database Blob object as " + ex.getMessage());
            }
            catch (InvocationTargetException ex) {
                throw new SQLException("Error : could not update database Blob object as " + ex.getMessage());
            }
            catch (IllegalAccessException ex) {
                throw new SQLException("Error : could not update database Blob object as " + ex.getMessage());
            }
            catch (IllegalArgumentException ex) {
                throw new SQLException("Error : could not update database Blob object as " + ex.getMessage());
            }
            finally {
                SqlResourceCloser.closeResources(rs, null);
            }
        }
    }

    public void updateBlob(ResultSet rs, Object data) throws SQLException {
        Object[] noParams = new Object[]{};
        if (data == null) {
            return;
        }
        try {
            Object blob;
            if (rs != null && rs.next()) {
                blob = this.m_getBLOBMethod.invoke((Object)rs, this.m_getBlobParams);
                if (blob == null) {
                    String errMsg = "the blob field is empty";
                    throw new SQLException(errMsg);
                }
            } else {
                throw new SQLException("Error : the blob query returned 0 rows");
            }
            OutputStream blobOutputStream = (OutputStream)this.m_getBytesOutputStream.invoke(blob, noParams);
            ObjectOutputStream oos = new ObjectOutputStream(blobOutputStream);
            oos.writeObject(data);
            oos.flush();
            blobOutputStream.flush();
            oos.close();
            blobOutputStream.close();
        }
        catch (IOException ex) {
            throw new SQLException("Error : could not update database Blob object as " + ex.getMessage());
        }
        catch (InvocationTargetException ex) {
            throw new SQLException("Error : could not update database Blob object as " + ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new SQLException("Error : could not update database Blob object as " + ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new SQLException("Error : could not update database Blob object as " + ex.getMessage());
        }
    }
}

