/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc.util;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.sql.Connection;
import java.sql.SQLException;

public class JDBCUtils {
    public static final String DEADLOCK_STATE = "40001";
    public static final String DEADLOCK_MSG = "SQL0911N";
    public static final int DEADLOCK_ERROR_CODE = 1205;

    public static boolean isDeadlockException(SQLException sqle) {
        boolean isDeadlockException;
        boolean bl = isDeadlockException = sqle.getErrorCode() == 1205;
        if (!isDeadlockException) {
            isDeadlockException = sqle.getMessage().indexOf("DEADLOCK_MSG") > -1 || sqle.getSQLState().equals(DEADLOCK_STATE) || sqle.getMessage().indexOf(DEADLOCK_STATE) > -1;
        }
        return isDeadlockException;
    }

    public static void comitTransaction(Connection connection) throws SQLException {
        try {
            connection.commit();
        }
        catch (SQLException e) {
            if (JDBCUtils.isDeadlockException(e)) {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.SQL_COMMIT_ERROR);
                connection.commit();
            }
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("non deadlock sql error on comit." + e.getMessage());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
            throw e;
        }
    }
}

