/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jdbc.util;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.ibm.cognos.jsmcommon.dbschemavalidator.DBSchemaValidator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SqlResourceCloser {
    public static void closeResources(ResultSet rs, Statement statement) {
        try {
            if (null != rs) {
                rs.close();
                rs = null;
            }
            if (null != statement) {
                statement.close();
                statement = null;
            }
        }
        catch (SQLException ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_FAILED_TO_CLOSE_RESOURCES);
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.GEN_3RD_PARTY_FAULT, new String[]{ex.getMessage() + ""});
        }
    }

    public static void releaseConnection(JDBCConnection connection) {
        try {
            NCConnection.instance().getConnectionFactory().releaseConnection(connection);
        }
        catch (SQLException ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.GEN_3RD_PARTY_FAULT, new String[]{"Unable to release connection: " + ex.getMessage()});
        }
    }

    public static void releaseConnection(JDBCConnection connection, DBSchemaValidator.ComponentName cName) {
        try {
            if (cName != null && (DBSchemaValidator.ComponentName.HTS.equals((Object)cName) || DBSchemaValidator.ComponentName.ANN.equals((Object)cName))) {
                NCConnection.instance("HTS").getConnectionFactory().releaseConnection(connection);
            } else {
                SqlResourceCloser.releaseConnection(connection);
            }
        }
        catch (SQLException ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, I18NCode.GEN_3RD_PARTY_FAULT, new String[]{"Unable to release connection: " + ex.getMessage()});
        }
    }
}

