/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jms;

import com.cognos.jsmcommon.jms.IDeliverable;
import com.cognos.jsmcommon.jms.IDeliveryChannel;
import com.cognos.jsmcommon.jms.event.DeliverEvent;
import com.cognos.jsmcommon.jms.event.DeliverEventListener;
import com.cognos.jsmcommon.jms.event.DeliverEventType;

public abstract class AbstractDeliveryChannel
implements IDeliveryChannel {
    int m_counter = 1;
    DeliverEventListener m_listener = null;
    volatile boolean deliveryFailedFlag = false;

    @Override
    public void registerListener(DeliverEventListener listener) {
        this.m_listener = listener;
    }

    @Override
    public synchronized int getSessionCount() {
        return this.m_counter++;
    }

    @Override
    public void fireChannelEvent(DeliverEventType type, IDeliverable message) {
        boolean bl = this.deliveryFailedFlag = type == DeliverEventType.CHANNEL_NOT_WORKING;
        if (this.getListener() != null) {
            DeliverEvent event = new DeliverEvent(this, type, message);
            this.getListener().onMessageDelivery(event);
        }
    }

    @Override
    public DeliverEventType determineChannelEvent(int expected_count, int actual_count) {
        DeliverEventType type = null;
        if (expected_count == 0) {
            type = DeliverEventType.MESSAGE_NO_TARGETS;
        } else if (expected_count == actual_count) {
            type = DeliverEventType.MESSAGE_DELIVERED;
        } else if (expected_count > actual_count && actual_count != 0) {
            type = DeliverEventType.MESSAGE_PARTIALLY_DELIVERED;
        } else if (actual_count == 0) {
            type = DeliverEventType.MESSAGE_NOT_DELIVERED;
        }
        return type;
    }

    protected DeliverEventListener getListener() {
        return this.m_listener;
    }

    @Override
    public synchronized boolean deliveryFailed() {
        return this.deliveryFailedFlag;
    }
}

