/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jms.client;

import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailMonitorServiceEventID;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseHistoryDetail;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.DateTimeProp;
import com.cognos.developer.schemas.bibus._3.HistoryDetail;
import com.cognos.developer.schemas.bibus._3.MonitorAddOptionBoolean;
import com.cognos.developer.schemas.bibus._3.MonitorAddOptionEnum;
import com.cognos.developer.schemas.bibus._3.MonitorServiceEventID;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.SeverityEnumProp;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.IClientBase;
import com.cognos.jsmcommon.soap.client.ports.MonitorServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.TimeUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class BiBusMonitorUtil {
    private static final int MAX_RETRIES = 10;
    private static final int WAIT_TIME = 60000;
    public static final String _EVENTID = "eventID";
    public static final String _INDEX_RESERVED = "eventID_index_for_future_use";
    public static final String _CREDENTIAL_PATH = "credentialPath";
    public static final String _PASSPORT = "passport";
    public static final String _PRODUCT_LOCALE = "productLocale";

    public static int callMonitorServiceAddDependentMsg(BiBusHeader header, String locale, I18NCode msg, String eventID) {
        return BiBusMonitorUtil.callMonitorService(header, locale, msg, eventID, true, SeverityEnum.info);
    }

    public static void callMonitorServiceAddErrorMsg(String msg, String eventID) throws TaskPersistLayerException {
        BiBusMonitorUtil.callMonitorServiceAddMsg(msg, eventID, SeverityEnum.error);
    }

    public static void callMonitorServiceAddErrorMsgs(String[] msg, String eventID) throws TaskPersistLayerException {
        if (eventID != null && msg != null) {
            TaskID taskID = TaskID.fromEventId(eventID);
            BaseHistoryDetail[] details = new BaseHistoryDetail[msg.length];
            for (int i = 0; i < msg.length; ++i) {
                details[i] = BiBusMonitorUtil.createHistoryDetails(msg[i], SeverityEnum.error);
            }
            TaskPersistLayer.getInstance().addTaskDetails(taskID, details);
        }
    }

    public static void callMonitorServiceAddInfoMsg(String msg, String eventID) throws TaskPersistLayerException {
        BiBusMonitorUtil.callMonitorServiceAddMsg(msg, eventID, SeverityEnum.info);
    }

    private static void callMonitorServiceAddMsg(String msg, String eventID, SeverityEnum code) throws TaskPersistLayerException {
        if (eventID != null) {
            TaskID taskID = TaskID.fromEventId(eventID);
            HistoryDetail historyDetail = BiBusMonitorUtil.createHistoryDetails(msg, code);
            TaskPersistLayer.getInstance().addTaskDetails(taskID, new BaseHistoryDetail[]{historyDetail});
        }
    }

    public static void callMonitorServiceAddMsg(String credentialPath, String locale, I18NCode msg, String eventID, SeverityEnum code) throws TaskPersistLayerException {
        if (eventID != null) {
            TaskID taskID = TaskID.fromEventId(eventID);
            HistoryDetail historyDetail = BiBusMonitorUtil.createHistoryDetails(msg, locale, code);
            TaskPersistLayer.getInstance().addTaskDetails(taskID, new BaseHistoryDetail[]{historyDetail});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int callMonitorService(BiBusHeader header, String locale, I18NCode msg, String eventID, boolean dependentStep, SeverityEnum code) {
        SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("BiBusMonitorUtil.callMonitorService entered  eventID: " + eventID + " dependentStep: " + dependentStep + " SeverityEnum: " + code);
        int subIndex = 0;
        JobBiBusHeaders headers = new JobBiBusHeaders(header);
        HistoryDetail historyDetail = BiBusMonitorUtil.createHistoryDetails(msg, locale, code);
        IClientBase port = null;
        try {
            Option[] options = null;
            if (dependentStep) {
                MonitorAddOptionBoolean maob = new MonitorAddOptionBoolean();
                maob.setName(MonitorAddOptionEnum.dependentStep);
                maob.setValue(dependentStep);
                options = new Option[]{maob};
            }
            port = Client.instance().getMonitorServiceClient(headers);
            AsynchReply reply = ((MonitorServiceClientPort)port).add(eventID, (BaseClass[])new BaseHistoryDetail[]{historyDetail}, null, options);
            while (reply != null && (reply.getStatus().equals((Object)AsynchReplyStatusEnum.working) || reply.getStatus().equals((Object)AsynchReplyStatusEnum.stillWorking))) {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("BiBusMonitorUtil.callMonitorService eventID: " + eventID + " sending MS.wait");
                reply = ((MonitorServiceClientPort)port).wait(reply.getPrimaryRequest(), null, null);
            }
            if (reply.getStatus() != null) {
                AsynchDetail[] ad = reply.getDetails();
                for (int i = 0; i < ad.length; ++i) {
                    MonitorServiceEventID msEventID;
                    if (!(ad[i] instanceof AsynchDetailMonitorServiceEventID) || (msEventID = ((AsynchDetailMonitorServiceEventID)ad[i]).getEventID()) == null) continue;
                    subIndex = msEventID.getStepID();
                    SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("BiBusMonitorUtil.callMonitorService eventID: " + eventID + " subIndex received from MS");
                }
            }
        }
        catch (SDKClientException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("Error in BiBusMonitorUtil.callMonitorService: " + e.getLocalizedMessage());
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("Error in BiBusMonitorUtil.callMonitorService: " + e.getLocalizedMessage());
        }
        finally {
            if (port != null) {
                port.close();
            }
        }
        SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("BiBusMonitorUtil.callMonitorService exited normally  eventID: " + eventID + " dependentStep: " + dependentStep + " SeverityEnum: " + code + " returning subIndex: " + subIndex);
        return subIndex;
    }

    public static HistoryDetail createHistoryDetails(I18NCode msg, String locale, SeverityEnum code) {
        Locale theLocale = LocaleUtil.getLocale(locale);
        String theMsg = I18NUtil.getMessage(msg, theLocale);
        return BiBusMonitorUtil.createHistoryDetails(theMsg, code);
    }

    public static HistoryDetail createHistoryDetails(String msg, SeverityEnum code) {
        HistoryDetail historyDetail = new HistoryDetail();
        DateTimeProp detailTimeProp = new DateTimeProp();
        Calendar now = TimeUtils.dateToUTCJavaCalendar(new Date());
        detailTimeProp.setValue(now);
        historyDetail.setDetailTime(detailTimeProp);
        StringProp stringProp = new StringProp();
        stringProp.setValue(msg);
        historyDetail.setDetail(stringProp);
        SeverityEnumProp sevProp = new SeverityEnumProp();
        sevProp.setValue(code);
        historyDetail.setSeverity(sevProp);
        return historyDetail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void callMonitorServiceNotify(String passport, String credentialPath, String eventID, int eventID_index, String status) throws SDKClientException, EMFSecurityException {
        SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("BiBusMonitorUtil.callMonitorServiceNotify entered  eventID: " + eventID + " eventID_index: " + eventID_index + " Status: " + status);
        int retries = 0;
        boolean retry = false;
        boolean passportOk = true;
        do {
            if (retry) {
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            boolean doLogOff = false;
            boolean authentic = false;
            JobBiBusHeaders headers = new JobBiBusHeaders();
            headers.setCAM();
            if (passportOk && passport != null && passport.length() > 0) {
                headers.setPassport(passport);
                try {
                    AuthenticatorFactory.getInstance().authenticate(headers);
                    authentic = true;
                }
                catch (SDKClientException e) {
                    passportOk = false;
                    SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("BiBusMonitorUtil.callMonitorServiceNotify SDK auth error: " + e.getLocalizedMessage());
                }
                catch (EMFSecurityException e) {
                    passportOk = false;
                    SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("BiBusMonitorUtil.callMonitorServiceNotify EMF auth error: " + e.getLocalizedMessage());
                }
            }
            if (!authentic && credentialPath != null && credentialPath.length() > 0) {
                headers.setCamCredential(credentialPath);
                try {
                    AuthenticatorFactory.getInstance().logon(headers);
                    authentic = true;
                    doLogOff = true;
                }
                catch (SDKClientException e) {
                    SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("BiBusMonitorUtil.callMonitorServiceNotify SDK logon error: " + e.getLocalizedMessage());
                }
                catch (EMFSecurityException e) {
                    SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("BiBusMonitorUtil.callMonitorServiceNotify EMF logon error: " + e.getLocalizedMessage());
                }
            }
            MonitorServiceClientPort port = Client.instance().getMonitorServiceClient(headers);
            try {
                if (!authentic) {
                    port.signNextRequest("DLS", false);
                }
                MonitorServiceEventID msEventID = new MonitorServiceEventID();
                msEventID.setEventID(eventID);
                msEventID.setStepID(eventID_index);
                port.notify(msEventID, status);
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("BiBusMonitorUtil.callMonitorServiceNotify exiting normally  eventID: " + eventID + " eventID_index: " + eventID_index);
                retry = false;
            }
            catch (Exception e) {
                retry = true;
                if (doLogOff) {
                    try {
                        AuthenticatorFactory.getInstance().logoff(headers.getBiBusHeader());
                    }
                    catch (Exception exp) {
                        SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("BiBusMonitorUtil.callMonitorServiceNotify logoff error" + e.getLocalizedMessage());
                    }
                }
                String debugMsg = "BiBusMonitorUtil.callMonitorServiceNotify will retry at most " + Integer.toString(10 - retries) + " more times as it failed with : " + e.getLocalizedMessage();
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(debugMsg);
                if (retries < 10) continue;
                LocalizableException le = new LocalizableException(I18NCode.GEN_THROWABLE_ERROR, new String[]{"Monitor Service Notify Failed with : " + e.getLocalizedMessage()}){};
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.FATAL, le);
            }
            finally {
                if (port != null) {
                    port.close();
                }
            }
        } while (retry && retries++ < 10);
    }

    public static void callMonitorServiceNotify(String passport, String credentialPath, String eventID, int eventID_index, EventStatus status) throws SDKClientException, EMFSecurityException {
        BiBusMonitorUtil.callMonitorServiceNotify(passport, credentialPath, eventID, eventID_index, status.statusName());
    }
}

