/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jms.client;

import com.cognos.jsmcommon.jms.IDeliverable;
import com.cognos.jsmcommon.jms.client.JMSMessageListener;
import com.cognos.jsmcommon.jms.event.DeliverEvent;
import com.cognos.jsmcommon.jms.event.DeliverEventType;
import com.ibm.cognos.jsmcommon.jms.JMSException;
import com.ibm.cognos.jsmcommon.jms.Message;

public class JMSAcknowledger {
    private JMSAcknowledger m_next;
    private IDeliverable m_noticecast;
    private Message m_jms;
    private DeliverEventType m_type;
    private JMSMessageListener m_listener;
    private boolean m_resend = false;
    private boolean m_been_resent = false;
    private boolean m_resend_complete = false;
    private boolean m_final = false;

    public JMSAcknowledger(JMSAcknowledger next, JMSMessageListener listener, IDeliverable noticecast, Message jms) {
        this.m_next = next;
        this.m_listener = listener;
        this.m_noticecast = noticecast;
        this.m_jms = jms;
    }

    public boolean acknowledge(DeliverEvent event) {
        boolean acknowledged = false;
        try {
            if (this.getNoticeCastMessage().equals(event.getMessage())) {
                this.debug("MATCH FOUND");
                if (this.hasBeenResent()) {
                    this.setResendComplete(true);
                }
                this.setType(event.getEventType());
                acknowledged = this.acknowledgeJMS();
            } else if (this.getNext() != null && this.getNext().acknowledge(event)) {
                this.setNext(null);
                acknowledged = this.acknowledgeJMS();
            }
            return acknowledged;
        }
        catch (Throwable e) {
            this.debug("Throwable in acknowledge tree." + e.getMessage());
            return acknowledged;
        }
    }

    private boolean acknowledgeJMS() {
        this.debug("ACKNOWLEDGING JMS MESSAGE");
        boolean acknowledged = false;
        if (this.getType() == null) {
            this.debug("NULL TYPE DISCOVERED!");
        } else if (this.getType().isEqualTo(DeliverEventType.MESSAGE_DELIVERED)) {
            acknowledged = this.processDeliveredMessage();
        } else if (this.getType().isEqualTo(DeliverEventType.MESSAGE_NO_TARGETS)) {
            acknowledged = this.processNoTargetMessage();
        } else if (this.getType().isEqualTo(DeliverEventType.MESSAGE_NOT_DELIVERED)) {
            acknowledged = this.processFailedMessage();
        } else if (this.getType().isEqualTo(DeliverEventType.MESSAGE_PARTIALLY_DELIVERED)) {
            acknowledged = this.processFailedMessage();
        } else if (this.getType().isEqualTo(DeliverEventType.MESSAGE_CORRUPTED)) {
            acknowledged = this.processCorruptedMessage();
        } else if (this.getType().isEqualTo(DeliverEventType.CHANNEL_NOT_WORKING)) {
            acknowledged = this.processChannelError();
        }
        return acknowledged;
    }

    private boolean finalAcknowledge() {
        try {
            if (!this.hasBeenAcknowledged() && this.getNext() == null) {
                this.getJMSMessage().acknowledge();
                this.setFinalAcknowledge();
            }
        }
        catch (JMSException jMSException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.hasBeenAcknowledged();
    }

    private boolean sendAgain() {
        boolean acknowledged = false;
        if (!this.hasBeenResent()) {
            this.debug("sending again");
            this.setBeenResent(true);
            this.m_listener.dispatchMessage(this.getNoticeCastMessage(), true);
        } else if (this.isResendComplete()) {
            this.debug("aborting resend");
            acknowledged = this.finalAcknowledge();
        } else if (this.hasBeenResent()) {
            this.debug("awaiting resend");
            try {
                this.m_jms.clearBody();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        return acknowledged;
    }

    private boolean processDeliveredMessage() {
        this.debug("PROCESSING DELIVERED MESSAGE");
        boolean acknowledged = false;
        if (this.getNext() != null) {
            this.debug("Attempting acknowledge next message");
            if (this.getNext().acknowledgeJMS()) {
                this.debug("message acknowledged");
                this.setNext(null);
                acknowledged = this.finalAcknowledge();
            }
        } else {
            this.debug("Final Acknowledging self");
            this.getNoticeCastMessage().wasSent(true);
            acknowledged = this.finalAcknowledge();
        }
        return acknowledged;
    }

    private boolean processCorruptedMessage() {
        boolean acknowledged = false;
        if (this.getNext() != null) {
            if (this.getNext().acknowledgeJMS()) {
                this.setNext(null);
                acknowledged = this.finalAcknowledge();
            }
        } else {
            acknowledged = this.finalAcknowledge();
        }
        return acknowledged;
    }

    private boolean processChannelError() {
        boolean acknowledged = false;
        if (this.getNext() != null && this.getNext().acknowledgeJMS()) {
            this.setNext(null);
        }
        return true;
    }

    private void debug(String message) {
    }

    private boolean processFailedMessage() {
        boolean acknowledged = false;
        this.debug("PROCESSING UNDELIVERED MESSAGE");
        if (this.getNext() == null && !this.isResend()) {
            this.debug("NO NEXT & NOT RESEND");
            this.debug("Flagging for resend");
            this.setResend(true);
        } else if (this.getNext() == null && this.isResend()) {
            this.debug("NO NEXT & RESEND");
            this.debug("Attempting resend");
            acknowledged = this.sendAgain();
        } else if (this.getNext() != null && !this.isResend()) {
            this.debug("NEXT & NOT RESEND");
            this.debug("Flagging for resend");
            this.setResend(true);
        } else if (this.getNext() != null && this.isResend()) {
            this.debug("NEXT & RESEND");
            this.debug("Attempting resend");
            acknowledged = this.sendAgain();
            this.debug("Attempting to acknowledge next");
            this.getNext().acknowledgeJMS();
        }
        this.debug("FINISHED PROCESSING UNDELIVERED MESSAGE ACKNOWLEDGED = " + (acknowledged ? "true" : "false"));
        return acknowledged;
    }

    private boolean processNoTargetMessage() {
        boolean acknowledged = false;
        if (this.getNext() != null) {
            if (this.getNext().acknowledgeJMS()) {
                this.setNext(null);
                acknowledged = this.finalAcknowledge();
            }
        } else {
            this.getNoticeCastMessage().wasSent(false);
            acknowledged = this.finalAcknowledge();
        }
        return acknowledged;
    }

    private void setType(DeliverEventType type) {
        this.m_type = type;
    }

    private DeliverEventType getType() {
        return this.m_type;
    }

    private IDeliverable getNoticeCastMessage() {
        return this.m_noticecast;
    }

    private Message getJMSMessage() {
        return this.m_jms;
    }

    private void setNext(JMSAcknowledger next) {
        this.m_next = next;
    }

    private JMSAcknowledger getNext() {
        return this.m_next;
    }

    private boolean isResend() {
        return this.m_resend;
    }

    private void setResend(boolean resend) {
        this.m_resend = resend;
        try {
            this.m_jms.clearBody();
        }
        catch (JMSException e) {
            this.debug("Failed to clear the memory");
        }
    }

    private boolean isResendComplete() {
        return this.m_resend_complete;
    }

    private void setResendComplete(boolean complete) {
        this.m_resend_complete = complete;
    }

    private boolean hasBeenResent() {
        return this.m_been_resent;
    }

    private void setBeenResent(boolean been_resent) {
        this.m_been_resent = been_resent;
    }

    private boolean hasBeenAcknowledged() {
        return this.m_final;
    }

    private void setFinalAcknowledge() {
        this.m_final = true;
    }

    public void debugChainLog() {
        System.out.println("I'm " + this);
        if (this.m_next != null) {
            this.m_next.debugChainLog();
        }
    }

    public String toString() {
        return super.toString() + " ; Noticecast: " + this.m_noticecast.toString() + " ; JMS: " + this.m_jms + " ; Ack: " + this.m_final;
    }
}

