/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jms.client;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jms.provider.NCJMSServer;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.ibm.cognos.jsmcommon.jms.JMSException;
import com.ibm.cognos.jsmcommon.jms.QueueConnection;
import com.ibm.cognos.jsmcommon.jms.QueueConnectionFactory;
import com.ibm.cognos.jsmcommon.jms.QueueSession;
import javax.naming.NamingException;

public class JMSConnection {
    private QueueConnection _qc;
    private String _clientId;

    public JMSConnection() throws PropertiesException, NamingException, JMSException {
        this(null);
    }

    public JMSConnection(String clientId) throws PropertiesException, NamingException, JMSException {
        this._clientId = clientId;
        this.establishConnection();
    }

    public synchronized QueueConnection getConnection() {
        return this._qc;
    }

    public synchronized void start() throws JMSException {
        this._qc.start();
    }

    public synchronized void stop() throws JMSException {
        this._qc.stop();
    }

    public synchronized void close() throws JMSException {
        this._qc.close();
    }

    private synchronized void establishConnection() throws NamingException, JMSException {
        if (this._qc == null) {
            try {
                QueueConnectionFactory qcf = NCJMSServer.instance().getQueueConnectionFactory();
                this._qc = this._clientId != null ? qcf.createQueueConnection(this._clientId, null) : qcf.createQueueConnection();
            }
            catch (JMSException e) {
                SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.GEN_3RD_PARTY_FAULT, new String[]{e.getMessage()});
                SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.FATAL, I18NCode.MSG_UNABLE_EST_JMS_CONNECTION);
                throw e;
            }
        }
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return this._qc.createQueueSession(transacted, acknowledgeMode);
    }
}

