/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jms.client;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.jms.IDeliverable;
import com.cognos.jsmcommon.jms.IDeliveryChannel;
import com.cognos.jsmcommon.jms.client.FaultedDeliverable;
import com.cognos.jsmcommon.jms.client.JMSAcknowledger;
import com.cognos.jsmcommon.jms.event.DeliverEvent;
import com.cognos.jsmcommon.jms.event.DeliverEventListener;
import com.cognos.jsmcommon.jms.event.DeliverEventType;
import com.cognos.jsmcommon.jms.provider.NCJMSObjectMessage;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.ibm.cognos.jsmcommon.jms.JMSException;
import com.ibm.cognos.jsmcommon.jms.Message;
import com.ibm.cognos.jsmcommon.jms.MessageListener;

public class JMSMessageListener
implements MessageListener,
DeliverEventListener {
    private IDeliveryChannel m_channel;
    private JMSAcknowledger m_head = null;
    private final Object m_head_lock = new Object();

    public JMSMessageListener(IDeliveryChannel channel) {
        this.m_channel = channel;
        this.m_channel.registerListener(this);
    }

    protected IDeliveryChannel getChannel() {
        return this.m_channel;
    }

    public IDeliveryChannel getDeliveryChannel() {
        return this.m_channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Message message) {
        IDeliverable nc_message = this.getDeliverable(message);
        boolean deliverMessage = true;
        if (nc_message == null) {
            deliverMessage = false;
            nc_message = new FaultedDeliverable();
        }
        Object object = this.m_head_lock;
        synchronized (object) {
            JMSAcknowledger new_head = new JMSAcknowledger(this.getHead(), this, nc_message, message);
            this.setHead(new_head);
        }
        if (deliverMessage) {
            try {
                this.dispatchMessage(nc_message);
            }
            catch (Throwable throwable) {}
        } else {
            DeliverEvent event = new DeliverEvent(this.getChannel(), DeliverEventType.MESSAGE_CORRUPTED, nc_message);
            this.onMessageDelivery(event);
        }
    }

    private IDeliverable getDeliverable(Message message) {
        IDeliverable nc_message = null;
        try {
            NCJMSObjectMessage bm = (NCJMSObjectMessage)message;
            nc_message = (IDeliverable)bm.getObject();
            message.clearBody();
        }
        catch (JMSException e) {
            this.logPreDeliveryError(I18NCode.MSG_UNABLE_RECOVER_JMS_MESSAGE);
        }
        catch (Throwable e) {
            this.logPreDeliveryError(I18NCode.MSG_UNABLE_RECOVER_JMS_MESSAGE);
        }
        return nc_message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessageDelivery(DeliverEvent e) {
        Object object = this.m_head_lock;
        synchronized (object) {
            if (this.getHead() == null) {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("Could not acknowledge message delivery for source " + e.getSource());
            } else if (this.getHead().acknowledge(e)) {
                this.setHead(null);
            }
        }
    }

    protected void dispatchMessage(IDeliverable message) {
        try {
            this.getChannel().dispatch(message);
        }
        catch (LocalizableException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, e);
        }
    }

    protected void dispatchMessage(IDeliverable message, boolean isResend) {
        try {
            this.getChannel().dispatch(message, isResend);
        }
        catch (LocalizableException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, e);
        }
    }

    private void setHead(JMSAcknowledger head) {
        this.m_head = head;
    }

    private JMSAcknowledger getHead() {
        return this.m_head;
    }

    private void logPreDeliveryError(I18NCode i18Ncode) {
        SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, i18Ncode);
    }
}

