/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jms.provider;

import com.cognos.jsmcommon.jms.provider.Target;
import com.ibm.cognos.jsmcommon.jms.Destination;
import com.ibm.cognos.jsmcommon.jms.JMSException;
import com.ibm.cognos.jsmcommon.jms.Message;
import java.util.HashMap;
import java.util.Map;

public class DestinationManager {
    private static DestinationManager m_instance = new DestinationManager();
    private Map m_destinations = new HashMap();

    private DestinationManager() {
    }

    public static DestinationManager getInstance() {
        return m_instance;
    }

    public synchronized void addDestination(Target destination) throws JMSException {
        if (this.m_destinations.containsKey(destination.getDestination())) {
            throw new JMSException("This destination has already been added to the server.");
        }
        this.m_destinations.put(destination.getDestination(), destination);
    }

    public void addMessage(Message message) throws JMSException {
        ((Target)this.m_destinations.get(message.getJMSDestination())).add(message);
    }

    public void acknowledge(Message message) throws JMSException {
        ((Target)this.m_destinations.get(message.getJMSDestination())).acknowledge(message);
    }

    public void recover(Message message) throws JMSException {
        ((Target)this.m_destinations.get(message.getJMSDestination())).recover(message);
    }

    public boolean contains(Destination destination) {
        return this.m_destinations.containsKey(destination);
    }
}

