/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jms.provider;

import com.cognos.jsmcommon.jms.provider.NCJMSDatabaseQueue;
import com.cognos.jsmcommon.jms.provider.NCJMSQueue;
import com.cognos.jsmcommon.jms.provider.NCJMSSession;
import com.ibm.cognos.jsmcommon.jms.Connection;
import com.ibm.cognos.jsmcommon.jms.ExceptionListener;
import com.ibm.cognos.jsmcommon.jms.JMSException;
import com.ibm.cognos.jsmcommon.jms.Session;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class NCJMSConnection
implements Connection {
    private String m_client_id;
    private ExceptionListener m_exception_listener;
    private boolean m_stopped = true;
    private Set m_sessions = new HashSet();
    private ThreadGroup m_group;
    private boolean m_closed = false;
    private static int m_nextSessionThreadNumber = 1;
    private static Map m_queues = new HashMap();

    public NCJMSConnection(String client_id) {
        this.m_client_id = client_id;
        this.m_group = new ThreadGroup("NCJMS.Sessions");
    }

    @Override
    public String getClientID() throws JMSException {
        this.checkClosed();
        return this.m_client_id;
    }

    @Override
    public void setClientID(String clientID) throws JMSException {
        this.checkClosed();
        this.m_client_id = clientID;
    }

    @Override
    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkClosed();
        return this.m_exception_listener;
    }

    @Override
    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.checkClosed();
        this.m_exception_listener = listener;
    }

    @Override
    public synchronized void start() throws JMSException {
        this.checkClosed();
        if (this.m_stopped) {
            this.m_stopped = false;
            Iterator itr = this.m_sessions.iterator();
            while (itr.hasNext()) {
                this.startSession((NCJMSSession)itr.next());
            }
        }
    }

    @Override
    public synchronized void stop() throws JMSException {
        this.checkClosed();
        if (this.m_stopped) {
            return;
        }
        this.m_stopped = true;
        Iterator iter = this.m_sessions.iterator();
        while (iter.hasNext()) {
            ((NCJMSSession)iter.next()).notifySession();
        }
    }

    @Override
    public synchronized void close() throws JMSException {
        if (this.m_closed) {
            return;
        }
        Session[] sessions = this.m_sessions.toArray(new Session[this.m_sessions.size()]);
        for (int i = 0; i < sessions.length; ++i) {
            sessions[i].close();
        }
        this.m_closed = true;
    }

    public synchronized void registerSession(NCJMSSession session) throws JMSException {
        this.checkClosed();
        this.m_sessions.add(session);
        if (!this.m_stopped) {
            this.startSession(session);
        }
    }

    public synchronized void removeSession(Session session) throws JMSException {
        this.checkClosed();
        this.m_sessions.remove(session);
    }

    public synchronized boolean isStopped() {
        return this.m_stopped;
    }

    public static synchronized NCJMSQueue createQueue(String queueName) {
        Object o = m_queues.get(queueName);
        if (o == null) {
            o = new NCJMSDatabaseQueue(queueName);
            m_queues.put(queueName, o);
        }
        return (NCJMSQueue)o;
    }

    private void checkClosed() throws JMSException {
        if (this.m_closed) {
            throw new IllegalStateException("The connection is closed.");
        }
    }

    private void startSession(NCJMSSession session) {
        if (session.isStarted()) {
            session.notifySession();
            return;
        }
        String threadname = "JMS.Session." + session.toString();
        threadname = this.m_client_id != null ? threadname + "." + this.m_client_id + "-" + m_nextSessionThreadNumber : threadname + "-" + m_nextSessionThreadNumber;
        m_nextSessionThreadNumber = m_nextSessionThreadNumber == Integer.MAX_VALUE ? 0 : ++m_nextSessionThreadNumber;
        session.setStarted();
        new Thread(this.m_group, session, threadname).start();
    }
}

