/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jms.provider;

import com.cognos.jsmcommon.jms.provider.NCJMSQueue;
import com.cognos.jsmcommon.jms.provider.PersistedJMSQueue;
import com.cognos.jsmcommon.jms.provider.metrics.JmsQueueMetrics;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.metrics.GlobalQueueMetricsMBean;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.ibm.cognos.jsmcommon.jms.JMSException;
import com.ibm.cognos.jsmcommon.jms.Message;
import java.util.Enumeration;

public class NCJMSDatabaseQueue
extends NCJMSQueue {
    private PersistedJMSQueue m_queue = PersistedJMSQueue.instance(this);
    private JmsQueueMetrics m_jmsQueueMetrics;

    public NCJMSDatabaseQueue(String name) {
        super(name);
        try {
            this.m_jmsQueueMetrics = new JmsQueueMetrics(this);
            this.m_jmsQueueMetrics.initPersistedMetrics();
        }
        catch (JMSException e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("Exception initialising queue metrics");
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
        }
        this.m_queue.start(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Message message) throws JMSException {
        try {
            this.m_queue.add(message);
        }
        catch (Exception e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
        }
        NCJMSDatabaseQueue nCJMSDatabaseQueue = this;
        synchronized (nCJMSDatabaseQueue) {
            this.notify();
        }
    }

    @Override
    public synchronized Message remove() throws JMSException {
        Message msg = this.m_queue.removeFirst();
        return msg;
    }

    @Override
    public void recover(Message message) throws JMSException {
        this.m_queue.recover(message);
    }

    @Override
    public synchronized void release() {
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForMessage(int timeout) throws InterruptedException {
        NCJMSDatabaseQueue nCJMSDatabaseQueue = this;
        synchronized (nCJMSDatabaseQueue) {
            this.m_queue.addWaitingThread();
            try {
                this.wait(timeout);
            }
            finally {
                this.m_queue.removeWaitingThread();
            }
        }
    }

    @Override
    public JmsQueueMetrics getMetrics() throws JMSException {
        if (this.m_jmsQueueMetrics == null) {
            throw new JMSException("Metrics were not initialized");
        }
        return this.m_jmsQueueMetrics;
    }

    @Override
    public GlobalQueueMetricsMBean getMetricsBean() throws JMSException {
        if (this.m_jmsQueueMetrics == null) {
            throw new JMSException("Metrics were not initialized");
        }
        return this.m_jmsQueueMetrics;
    }

    @Override
    protected void deleteMessage(Message message) {
        try {
            this.m_queue.delete(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Enumeration getEnumeration() throws JMSException {
        return this.m_queue.getEnumeration();
    }
}

