/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jms.provider;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jms.provider.INCJMSMessageProxy;
import com.cognos.jsmcommon.jms.provider.NCJMSQueue;
import com.cognos.jsmcommon.jms.provider.metrics.JmsQueueMetrics;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.metrics.GlobalQueueMetricsMBean;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.TempFilesUtil;
import com.ibm.cognos.jsmcommon.jms.JMSException;
import com.ibm.cognos.jsmcommon.jms.Message;
import java.io.File;
import java.util.Enumeration;
import java.util.LinkedList;

public class NCJMSFileQueue
extends NCJMSQueue {
    boolean m_is_loading;
    private LinkedList m_queue = new LinkedList();
    private static final boolean m_persist_messages = true;

    public NCJMSFileQueue(String name) {
        super(name);
        this.loadQueue();
    }

    @Override
    protected void deleteMessage(Message message) {
        try {
            INCJMSMessageProxy proxy = (INCJMSMessageProxy)((Object)message);
            proxy.deleteProxy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void loadQueue() {
        this.setIsLoading(true);
        File[] files = TempFilesUtil.getTempFiles(this.getQueueName());
        for (int i = 0; files != null && i < files.length; ++i) {
            try {
                Message message = (Message)TempFilesUtil.readObjectFromFile(files[i]);
                if (message == null) continue;
                this.add(message);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setIsLoading(false);
    }

    protected void persistMessage(Message message) {
        if (this.isLoading()) {
            return;
        }
        try {
            INCJMSMessageProxy proxy = (INCJMSMessageProxy)((Object)message);
            proxy.saveProxy();
            proxy.clearMemory();
        }
        catch (Exception e) {
            File dir = TempFilesUtil.getStorageRootDir(this.toString());
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_UNABLE_PERSIST_FILE, new Object[]{dir});
        }
    }

    @Override
    public synchronized void add(Message message) throws JMSException {
        this.persistMessage(message);
        this.m_queue.add(message);
        this.notify();
    }

    @Override
    public synchronized Message remove() throws JMSException {
        String name = this.getQueueName();
        if (this.m_queue.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        return this.m_queue.isEmpty() ? null : (Message)this.m_queue.removeFirst();
    }

    @Override
    public void recover(Message message) throws JMSException {
        throw new UnsupportedOperationException("NCJMSFileQueue.recover is unsupported");
    }

    protected boolean isLoading() {
        return this.m_is_loading;
    }

    protected void setIsLoading(boolean is_loading) {
        this.m_is_loading = is_loading;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForMessage(int timeout) throws InterruptedException {
        NCJMSFileQueue nCJMSFileQueue = this;
        synchronized (nCJMSFileQueue) {
            this.wait(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        String name = this.getQueueName();
        NCJMSFileQueue nCJMSFileQueue = this;
        synchronized (nCJMSFileQueue) {
            this.notifyAll();
        }
    }

    @Override
    public Enumeration getEnumeration() throws JMSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public JmsQueueMetrics getMetrics() throws JMSException {
        throw new UnsupportedOperationException("Mterics not implemented for a file queue");
    }

    @Override
    public GlobalQueueMetricsMBean getMetricsBean() throws JMSException {
        throw new UnsupportedOperationException("Mterics not implemented for a file queue");
    }
}

