/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jms.provider;

import com.cognos.jsmcommon.jms.provider.INCJMSMessage;
import com.cognos.jsmcommon.jms.provider.NCJMSSession;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.ibm.cognos.jsmcommon.jms.Destination;
import com.ibm.cognos.jsmcommon.jms.JMSException;
import com.ibm.cognos.jsmcommon.jms.MessageFormatException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public abstract class NCJMSMessage
implements INCJMSMessage {
    private String m_message_id;
    private transient Destination m_destination;
    private long m_timestamp;
    private int m_delivery_mode;
    private String m_correlation_id;
    private Destination m_reply_to;
    private boolean m_redelivered;
    private String m_type;
    private long m_expiration;
    private int m_priority;
    private Map m_properties_map = new Hashtable();
    private transient NCJMSSession m_session = null;
    private static String ZIP_IT_STRING = null;

    @Override
    public void setSession(NCJMSSession session) {
        this.m_session = session;
    }

    @Override
    public NCJMSSession getSession() {
        return this.m_session;
    }

    @Override
    public String getJMSMessageID() throws JMSException {
        return this.m_message_id;
    }

    @Override
    public void setJMSMessageID(String id) throws JMSException {
        this.m_message_id = id;
    }

    @Override
    public long getJMSTimestamp() throws JMSException {
        return this.m_timestamp;
    }

    @Override
    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.m_timestamp = timestamp;
    }

    @Override
    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this.m_correlation_id.getBytes();
    }

    @Override
    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        this.m_correlation_id = new String(correlationID);
    }

    @Override
    public void setJMSCorrelationID(String correlationID) throws JMSException {
        this.m_correlation_id = correlationID;
    }

    @Override
    public String getJMSCorrelationID() throws JMSException {
        return this.m_correlation_id;
    }

    @Override
    public Destination getJMSReplyTo() throws JMSException {
        return this.m_reply_to;
    }

    @Override
    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        this.m_reply_to = replyTo;
    }

    @Override
    public Destination getJMSDestination() throws JMSException {
        return this.m_destination;
    }

    @Override
    public void setJMSDestination(Destination destination) throws JMSException {
        this.m_destination = destination;
    }

    @Override
    public int getJMSDeliveryMode() throws JMSException {
        return this.m_delivery_mode;
    }

    @Override
    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        this.m_delivery_mode = deliveryMode;
    }

    @Override
    public boolean getJMSRedelivered() throws JMSException {
        return this.m_redelivered;
    }

    @Override
    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this.m_redelivered = redelivered;
    }

    @Override
    public String getJMSType() throws JMSException {
        return this.m_type;
    }

    @Override
    public void setJMSType(String type) throws JMSException {
        this.m_type = type;
    }

    @Override
    public long getJMSExpiration() throws JMSException {
        return this.m_expiration;
    }

    @Override
    public void setJMSExpiration(long expiration) throws JMSException {
        this.m_expiration = expiration;
    }

    @Override
    public int getJMSPriority() throws JMSException {
        return this.m_priority;
    }

    @Override
    public void setJMSPriority(int priority) throws JMSException {
        this.m_priority = priority;
    }

    @Override
    public void clearProperties() throws JMSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean propertyExists(String name) throws JMSException {
        return this.m_properties_map.containsKey(name);
    }

    @Override
    public boolean getBooleanProperty(String name) throws JMSException {
        return (Boolean)this.getProperty(name, Boolean.class);
    }

    @Override
    public byte getByteProperty(String name) throws JMSException {
        return (Byte)this.getProperty(name, Byte.class);
    }

    @Override
    public short getShortProperty(String name) throws JMSException {
        return (Short)this.getProperty(name, Short.class);
    }

    @Override
    public int getIntProperty(String name) throws JMSException {
        return (Integer)this.getProperty(name, Integer.class);
    }

    @Override
    public long getLongProperty(String name) throws JMSException {
        return (Long)this.getProperty(name, Long.class);
    }

    @Override
    public float getFloatProperty(String name) throws JMSException {
        return ((Float)this.getProperty(name, Float.class)).floatValue();
    }

    @Override
    public double getDoubleProperty(String name) throws JMSException {
        return (Double)this.getProperty(name, Double.class);
    }

    @Override
    public String getStringProperty(String name) throws JMSException {
        return (String)this.getProperty(name, String.class);
    }

    @Override
    public Object getObjectProperty(String name) throws JMSException {
        return this.m_properties_map.get(name);
    }

    @Override
    public Enumeration getPropertyNames() throws JMSException {
        Vector names = new Vector(this.m_properties_map.size());
        Iterator itr = this.m_properties_map.keySet().iterator();
        while (itr.hasNext()) {
            names.add(itr.next());
        }
        return names.elements();
    }

    @Override
    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.m_properties_map.put(name, value);
    }

    @Override
    public void setByteProperty(String name, byte value) throws JMSException {
        this.m_properties_map.put(name, new Byte(value));
    }

    @Override
    public void setShortProperty(String name, short value) throws JMSException {
        this.m_properties_map.put(name, new Short(value));
    }

    @Override
    public void setIntProperty(String name, int value) throws JMSException {
        this.m_properties_map.put(name, new Integer(value));
    }

    @Override
    public void setLongProperty(String name, long value) throws JMSException {
        this.m_properties_map.put(name, new Long(value));
    }

    @Override
    public void setFloatProperty(String name, float value) throws JMSException {
        this.m_properties_map.put(name, new Float(value));
    }

    @Override
    public void setDoubleProperty(String name, double value) throws JMSException {
        this.m_properties_map.put(name, new Double(value));
    }

    @Override
    public void setStringProperty(String name, String value) throws JMSException {
        this.validateValue(value);
        this.m_properties_map.put(name, value);
    }

    @Override
    public void setObjectProperty(String name, Object value) throws JMSException {
        this.validObjectProperty(value);
        this.m_properties_map.put(name, value);
    }

    @Override
    public void acknowledge() throws JMSException {
        if (this.m_session != null) {
            this.m_session.acknowledge(this);
        }
    }

    @Override
    public void clearBody() throws JMSException {
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        try {
            if (obj != null && this.getClass().equals(obj.getClass())) {
                INCJMSMessage other = (INCJMSMessage)obj;
                equal = equal && this.m_correlation_id != null ? this.m_correlation_id.equals(other.getJMSCorrelationID()) : other.getJMSCorrelationID() == null;
                boolean bl = equal = equal && this.m_delivery_mode == other.getJMSDeliveryMode();
                equal = equal && this.m_destination != null ? this.m_destination.equals(other.getJMSDestination()) : other.getJMSDestination() == null;
                equal = equal && this.m_expiration == other.getJMSExpiration();
                equal = equal && this.m_priority == other.getJMSPriority();
                Enumeration propNames = this.getPropertyNames();
                while (propNames.hasMoreElements()) {
                    String key = (String)propNames.nextElement();
                    equal = equal && this.getObjectProperty(key) != null ? this.getObjectProperty(key).equals(other.getObjectProperty(key)) : other.getObjectProperty(key) == null;
                }
                boolean bl2 = equal = equal && this.m_redelivered == other.getJMSRedelivered();
                equal = equal && this.m_reply_to != null ? this.m_reply_to.equals(other.getJMSReplyTo()) : other.getJMSReplyTo() == null;
                boolean bl3 = equal = equal && this.m_timestamp == other.getJMSTimestamp();
                equal = equal && this.m_type != null ? this.m_type.equals(other.getJMSType()) : other.getJMSType() == null;
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return equal;
    }

    protected boolean isMailMessageZipped() {
        if (ZIP_IT_STRING == null) {
            try {
                ZIP_IT_STRING = CRNProperties.getInstance().getProperty("zip.mail");
                if (ZIP_IT_STRING == null || "".equals(ZIP_IT_STRING)) {
                    ZIP_IT_STRING = "true";
                }
            }
            catch (PropertiesException e) {
                ZIP_IT_STRING = "true";
            }
        }
        return Boolean.valueOf(ZIP_IT_STRING);
    }

    private Object getProperty(String key, Class clazz) throws MessageFormatException {
        Object obj = this.m_properties_map.get(key);
        if (obj == null) {
            throw new MessageFormatException("No value is linked to " + key);
        }
        if (!obj.getClass().equals(clazz)) {
            throw new MessageFormatException("Requested: " + clazz.toString() + " Found: " + obj.getClass().toString());
        }
        return obj;
    }

    private void validateValue(Object obj) throws JMSException {
        if (obj == null) {
            throw new MessageFormatException("A null value is not valid");
        }
    }

    private void validObjectProperty(Object obj) throws JMSException {
        this.validateValue(obj);
        boolean valid = obj.getClass().equals(Boolean.class);
        valid = valid || obj.getClass().equals(Byte.class);
        valid = valid || obj.getClass().equals(Short.class);
        valid = valid || obj.getClass().equals(Integer.class);
        valid = valid || obj.getClass().equals(Long.class);
        valid = valid || obj.getClass().equals(Float.class);
        valid = valid || obj.getClass().equals(Double.class);
        boolean bl = valid = valid || obj.getClass().equals(String.class);
        if (!valid) {
            throw new MessageFormatException("Invalid type: " + obj.getClass().toString() + ".  Type must be one of Boolean, Byte, Short, Integer, Long, Float, Double, or String");
        }
    }
}

