/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jms.provider;

import com.cognos.jsmcommon.jms.provider.NCJMSSession;
import com.ibm.cognos.jsmcommon.jms.JMSException;
import com.ibm.cognos.jsmcommon.jms.Message;
import com.ibm.cognos.jsmcommon.jms.MessageConsumer;
import com.ibm.cognos.jsmcommon.jms.MessageListener;
import com.ibm.cognos.jsmcommon.jms.Session;

public abstract class NCJMSMessageConsumer
implements MessageConsumer {
    private NCJMSSession m_session;
    private MessageListener m_listener = null;
    private boolean m_closed = false;

    public NCJMSMessageConsumer(Session session) {
        this.m_session = (NCJMSSession)session;
    }

    @Override
    public String getMessageSelector() throws JMSException {
        throw new JMSException("MessageConsumer.getMessageSelector() unsupported.");
    }

    @Override
    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return this.m_listener;
    }

    @Override
    public void setMessageListener(MessageListener listener) throws JMSException {
        this.checkClosed();
        this.m_listener = listener;
        if (listener != null) {
            this.m_session.notifySession();
        }
    }

    @Override
    public Message receive(long timeout) throws JMSException {
        throw new JMSException("MessageConsumer.receive(..) unsupported.");
    }

    @Override
    public Message receiveNoWait() throws JMSException {
        throw new JMSException("MessageConsumer.receiveNoWait() unsupported.");
    }

    public NCJMSSession getSession() throws JMSException {
        this.checkClosed();
        return this.m_session;
    }

    public boolean equals(Object obj) {
        boolean equal = obj instanceof NCJMSMessageConsumer;
        if (equal) {
            NCJMSMessageConsumer other = (NCJMSMessageConsumer)obj;
            equal = equal && this.m_listener.equals(other.m_listener);
            equal = equal && this.m_closed == other.m_closed;
        }
        return equal;
    }

    void checkClosed() throws JMSException {
        if (this.m_closed) {
            throw new IllegalStateException("The message consumer is closed.");
        }
    }

    boolean isClosed() {
        return this.m_closed;
    }

    void setClosed(boolean closed) {
        this.m_closed = closed;
    }
}

