/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jms.provider;

import com.cognos.jsmcommon.jms.provider.NCJMSSession;
import com.ibm.cognos.jsmcommon.jms.JMSException;
import com.ibm.cognos.jsmcommon.jms.MessageProducer;
import com.ibm.cognos.jsmcommon.jms.Session;

public abstract class NCJMSMessageProducer
implements MessageProducer {
    private NCJMSSession m_session;
    private int m_delivery_mode = 2;
    private boolean m_disable_message_id = false;
    private boolean m_disable_message_time_stamp = false;
    private int m_priority = 4;
    private long m_time_to_live = 0L;

    public NCJMSMessageProducer(Session session) {
        this.m_session = (NCJMSSession)session;
    }

    @Override
    public void setDisableMessageID(boolean value) throws JMSException {
        this.m_disable_message_id = value;
    }

    @Override
    public boolean getDisableMessageID() throws JMSException {
        return this.m_disable_message_id;
    }

    @Override
    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.m_disable_message_time_stamp = value;
    }

    @Override
    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.m_disable_message_time_stamp;
    }

    @Override
    public void setDeliveryMode(int deliveryMode) throws JMSException {
        if (deliveryMode != 1 && deliveryMode != 2) {
            throw new JMSException("Illegal Parameter: Value must be DeliveryMode.NON_PERSISTENT or DeliveryMode.PERSISTENT.");
        }
        this.m_delivery_mode = deliveryMode;
    }

    @Override
    public int getDeliveryMode() throws JMSException {
        return this.m_delivery_mode;
    }

    @Override
    public void setPriority(int defaultPriority) throws JMSException {
        if (defaultPriority < 0 || defaultPriority > 9) {
            throw new JMSException("Illegal Parameter: Value must be between 0 & 9 inclusive.");
        }
        this.m_priority = defaultPriority;
    }

    @Override
    public int getPriority() throws JMSException {
        return this.m_priority;
    }

    @Override
    public void setTimeToLive(long timeToLive) throws JMSException {
        this.m_time_to_live = timeToLive;
    }

    @Override
    public long getTimeToLive() throws JMSException {
        return this.m_time_to_live;
    }

    @Override
    public void close() throws JMSException {
        throw new JMSException("MessageProducer.close() unsupported.");
    }

    public NCJMSSession getSession() {
        return this.m_session;
    }
}

