/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jms.provider;

import com.cognos.jsmcommon.jms.provider.NCJMSMessage;
import com.cognos.jsmcommon.util.ZipUtils;
import com.ibm.cognos.jsmcommon.jms.JMSException;
import com.ibm.cognos.jsmcommon.jms.ObjectMessage;
import java.io.IOException;
import java.io.Serializable;

public class NCJMSObjectMessage
extends NCJMSMessage
implements ObjectMessage {
    private byte[] m_object_bytes;
    private Object m_object;

    public NCJMSObjectMessage() {
    }

    public NCJMSObjectMessage(Serializable object) throws JMSException {
        this.setObject(object);
    }

    @Override
    public void setObject(Serializable object) throws JMSException {
        try {
            if (this.isMailMessageZipped()) {
                this.m_object_bytes = ZipUtils.gzip(object);
            } else {
                this.m_object = object;
            }
        }
        catch (IOException e) {
            throw new JMSException(e.getLocalizedMessage());
        }
    }

    @Override
    public Serializable getObject() throws JMSException {
        Object object = null;
        if (!this.isMailMessageZipped()) {
            object = this.m_object;
        } else {
            try {
                object = ZipUtils.gunzipObject(this.m_object_bytes);
            }
            catch (IOException e) {
                throw new JMSException(e.getLocalizedMessage());
            }
            catch (ClassNotFoundException e) {
                throw new JMSException(e.getLocalizedMessage());
            }
        }
        return (Serializable)object;
    }
}

