/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jms.provider;

import com.cognos.jsmcommon.jms.provider.NCJMSDatabaseQueue;
import com.cognos.jsmcommon.jms.provider.NCJMSDestination;
import com.cognos.jsmcommon.jms.provider.metrics.JmsQueueMetrics;
import com.cognos.jsmcommon.metrics.GlobalQueueMetricsMBean;
import com.ibm.cognos.jsmcommon.jms.JMSException;
import com.ibm.cognos.jsmcommon.jms.Message;
import com.ibm.cognos.jsmcommon.jms.Queue;
import java.util.Enumeration;

public abstract class NCJMSQueue
extends NCJMSDestination
implements Queue {
    private final String m_name;
    private static final boolean m_use_db_queue = true;

    public static NCJMSDestination createNewQueue(String name) {
        return new NCJMSDatabaseQueue(name);
    }

    public NCJMSQueue(String name) {
        this.m_name = name;
    }

    @Override
    public String getQueueName() {
        return this.m_name;
    }

    @Override
    public String toString() {
        return this.m_name;
    }

    public boolean equals(Object o) {
        boolean equal = false;
        if (o != null && o.getClass().equals(this.getClass())) {
            equal = ((NCJMSQueue)o).m_name.equals(this.m_name);
        }
        return equal;
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    @Override
    public synchronized void acknowledge(Message message) throws JMSException {
        if (message.getJMSDeliveryMode() == 2) {
            this.deleteMessage(message);
        }
    }

    public abstract void release();

    public abstract Message remove() throws JMSException;

    protected abstract void deleteMessage(Message var1);

    @Override
    public abstract void add(Message var1) throws JMSException;

    public abstract void waitForMessage(int var1) throws InterruptedException;

    public abstract Enumeration getEnumeration() throws JMSException;

    public abstract JmsQueueMetrics getMetrics() throws JMSException;

    public abstract GlobalQueueMetricsMBean getMetricsBean() throws JMSException;
}

