/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jms.provider;

import com.cognos.jsmcommon.jms.IDeliveryChannel;
import com.cognos.jsmcommon.jms.client.JMSMessageListener;
import com.cognos.jsmcommon.jms.provider.INCJMSMessage;
import com.cognos.jsmcommon.jms.provider.NCJMSMessageConsumer;
import com.cognos.jsmcommon.jms.provider.NCJMSQueue;
import com.ibm.cognos.jsmcommon.jms.JMSException;
import com.ibm.cognos.jsmcommon.jms.Message;
import com.ibm.cognos.jsmcommon.jms.MessageListener;
import com.ibm.cognos.jsmcommon.jms.Queue;
import com.ibm.cognos.jsmcommon.jms.QueueReceiver;
import com.ibm.cognos.jsmcommon.jms.Session;

public class NCJMSQueueReceiver
extends NCJMSMessageConsumer
implements QueueReceiver {
    NCJMSQueue m_queue;

    public NCJMSQueueReceiver(Session session, Queue queue) {
        super(session);
        this.m_queue = (NCJMSQueue)queue;
    }

    @Override
    public Queue getQueue() throws JMSException {
        this.checkClosed();
        return this.m_queue;
    }

    @Override
    public Message receive() throws JMSException {
        this.checkClosed();
        MessageListener listener = this.getMessageListener();
        IDeliveryChannel dc = null;
        if (listener != null && listener instanceof JMSMessageListener) {
            dc = ((JMSMessageListener)listener).getDeliveryChannel();
        }
        Message message = null;
        while (message == null && !this.isClosed()) {
            if (message == null) {
                message = this.m_queue.remove();
            }
            if (message == null) {
                try {
                    this.m_queue.waitForMessage(30000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.isClosed()) break;
                message = this.m_queue.remove();
            }
            if (message != null) continue;
            try {
                this.m_queue.waitForMessage(0);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (message != null) {
            ((INCJMSMessage)message).setSession(this.getSession());
            this.getSession().addUnacknowledged(message);
        }
        return message;
    }

    @Override
    public void close() throws JMSException {
        if (this.isClosed()) {
            return;
        }
        ((NCJMSQueue)this.getQueue()).release();
        this.setClosed(true);
    }
}

