/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jms.provider;

import com.cognos.jsmcommon.jms.provider.NCJMSMessageProducer;
import com.ibm.cognos.jsmcommon.jms.Destination;
import com.ibm.cognos.jsmcommon.jms.JMSException;
import com.ibm.cognos.jsmcommon.jms.Message;
import com.ibm.cognos.jsmcommon.jms.Queue;
import com.ibm.cognos.jsmcommon.jms.QueueSender;
import com.ibm.cognos.jsmcommon.jms.Session;
import java.util.Date;

public class NCJMSQueueSender
extends NCJMSMessageProducer
implements QueueSender {
    private Queue m_queue;
    private int m_counter = 1;

    public NCJMSQueueSender(Session session, Queue queue) {
        super(session);
        this.m_queue = queue;
    }

    @Override
    public Queue getQueue() throws JMSException {
        return this.m_queue;
    }

    @Override
    public void send(Message message) throws JMSException {
        this.send(message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
    }

    @Override
    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (this.m_queue == null) {
            throw new UnsupportedOperationException("No or invalid Queue");
        }
        message.setJMSDestination(this.m_queue);
        message.setJMSDeliveryMode(deliveryMode);
        message.setJMSPriority(priority);
        message.setJMSExpiration(timeToLive);
        if (!this.getDisableMessageTimestamp()) {
            message.setJMSTimestamp(new Date().getTime());
        }
        this.getSession().send(message);
    }

    @Override
    public void send(Queue queue, Message message) throws JMSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Destination getDestination() throws JMSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void send(Destination arg0, Message arg1, int arg2, int arg3, long arg4) throws JMSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void send(Destination arg0, Message arg1) throws JMSException {
        throw new UnsupportedOperationException();
    }
}

