/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jms.provider;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jms.provider.DestinationManager;
import com.cognos.jsmcommon.jms.provider.NCJMSConnection;
import com.cognos.jsmcommon.jms.provider.NCJMSDatabaseQueue;
import com.cognos.jsmcommon.jms.provider.NCJMSQueue;
import com.cognos.jsmcommon.jms.provider.NCJMSQueueBrowser;
import com.cognos.jsmcommon.jms.provider.NCJMSQueueConnection;
import com.cognos.jsmcommon.jms.provider.NCJMSQueueReceiver;
import com.cognos.jsmcommon.jms.provider.NCJMSQueueSender;
import com.cognos.jsmcommon.jms.provider.NCJMSSession;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.ibm.cognos.jsmcommon.jms.Destination;
import com.ibm.cognos.jsmcommon.jms.InvalidDestinationException;
import com.ibm.cognos.jsmcommon.jms.JMSException;
import com.ibm.cognos.jsmcommon.jms.Message;
import com.ibm.cognos.jsmcommon.jms.MessageConsumer;
import com.ibm.cognos.jsmcommon.jms.MessageListener;
import com.ibm.cognos.jsmcommon.jms.MessageProducer;
import com.ibm.cognos.jsmcommon.jms.Queue;
import com.ibm.cognos.jsmcommon.jms.QueueBrowser;
import com.ibm.cognos.jsmcommon.jms.QueueReceiver;
import com.ibm.cognos.jsmcommon.jms.QueueSender;
import com.ibm.cognos.jsmcommon.jms.QueueSession;
import java.util.Iterator;

public class NCJMSQueueSession
extends NCJMSSession
implements QueueSession {
    private transient MessageConsumer m_consumer;
    private boolean m_hasStarted;
    private Thread m_runningThread;

    public NCJMSQueueSession(NCJMSQueueConnection connection, boolean transacted, int acknowledge_mode) {
        super(connection, transacted, acknowledge_mode);
    }

    @Override
    public Queue createQueue(String queueName) throws JMSException {
        return NCJMSConnection.createQueue(queueName);
    }

    @Override
    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        NCJMSQueueSession.trace("Creating receiver for Queue [" + queue.getQueueName() + "]");
        this.checkClosed();
        if (this.m_consumer != null) {
            NCJMSQueueSession.trace("Reciever already created on this Session.");
            throw new JMSException("Reciever already created on this Session.");
        }
        NCJMSQueueReceiver receiver = new NCJMSQueueReceiver(this, queue);
        NCJMSQueueSession.trace("Registering new receiver.");
        this.registerConsumer(receiver);
        return receiver;
    }

    @Override
    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        throw new JMSException("QueueSession.createReceiver(..) unsupported.");
    }

    @Override
    public QueueSender createSender(Queue queue) throws JMSException {
        NCJMSQueueSession.trace("Creating receiver for Queue [" + queue.getQueueName() + "]");
        this.checkClosed();
        if (!DestinationManager.getInstance().contains(queue)) {
            NCJMSQueueSession.trace("Queue does not exist.");
            throw new InvalidDestinationException("Queue does not exist.");
        }
        return new NCJMSQueueSender(this, queue);
    }

    @Override
    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        NCJMSQueueBrowser queueBrowser = null;
        if (queue instanceof NCJMSQueue) {
            queueBrowser = new NCJMSQueueBrowser((NCJMSDatabaseQueue)queue);
        }
        return queueBrowser;
    }

    @Override
    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        throw new JMSException("QueueSession.createBrowser(..) unsupported.");
    }

    @Override
    public synchronized void recover() throws JMSException {
        DestinationManager dm = DestinationManager.getInstance();
        Iterator iter = this.getUnacknowledged().iterator();
        while (iter.hasNext()) {
            dm.recover((Message)iter.next());
        }
        this.getUnacknowledged().clear();
    }

    public synchronized void registerConsumer(MessageConsumer consumer) {
        if (!consumer.getClass().equals(NCJMSQueueReceiver.class)) {
            throw new IllegalArgumentException();
        }
        this.m_consumer = (NCJMSQueueReceiver)consumer;
        this.notify();
    }

    synchronized MessageConsumer getConsumer() {
        try {
            while (this.m_consumer == null) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.m_consumer;
    }

    @Override
    public MessageListener getMessageListener() throws JMSException {
        return this.m_consumer == null ? null : this.m_consumer.getMessageListener();
    }

    public synchronized MessageConsumer removeConsumer() {
        MessageConsumer consumer = this.m_consumer;
        this.m_consumer = null;
        return consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        NCJMSQueueSession.trace("Starting QueueSession thread.");
        NCJMSQueueSession nCJMSQueueSession = this;
        synchronized (nCJMSQueueSession) {
            if (this.m_runningThread != null) {
                throw new IllegalStateException("Starting an already started session");
            }
            this.m_runningThread = Thread.currentThread();
        }
        this.setStarted();
        while (!this.isClosed()) {
            try {
                NCJMSQueueSession.trace("Getting Message Listener for QueueSession.");
                MessageConsumer consumer = this.getConsumer();
                MessageListener listener = null;
                if (consumer != null) {
                    listener = consumer.getMessageListener();
                }
                NCJMSQueueSession nCJMSQueueSession2 = this;
                synchronized (nCJMSQueueSession2) {
                    if (!this.isClosed() && (this.getConnection().isStopped() || listener == null)) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (this.isClosed()) {
                    NCJMSQueueSession.trace("Session closed, breaking thread.");
                    break;
                }
                NCJMSQueueSession.trace("Session not closed, processing message.");
                if (listener != null) {
                    Message message = null;
                    NCJMSQueueSession.trace("Waiting to receive new message.");
                    message = this.m_consumer.receive();
                    if (message != null) {
                        NCJMSQueueSession.trace("Delivering message to listener.");
                        listener.onMessage(message);
                        if (this.getAcknowledgeMode() != 1) continue;
                        this.acknowledge(message);
                        continue;
                    }
                    NCJMSQueueSession.trace("No message returned, attempt to receive next message.");
                    continue;
                }
                NCJMSQueueSession.trace("No listener retrieved, attempt to retrieve listener again.");
            }
            catch (JMSException e) {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.INFO, I18NCode.MSG_ERROR_DELIVERING_MESSAGE);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            catch (IllegalStateException e) {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(e);
            }
            catch (Throwable t) {
                SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug(t);
            }
            finally {
                NCJMSQueueSession e = this;
                synchronized (e) {
                    if (this.isClosed()) {
                        this.m_runningThread = null;
                    }
                }
            }
        }
        NCJMSQueueSession.trace("Stopping QueueSession thread.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws JMSException {
        if (this.isClosed()) {
            return;
        }
        try {
            this.setClosed(true);
            NCJMSQueueSession.trace("Removing Message Consumer from the Session.");
            MessageConsumer consumer = this.removeConsumer();
            if (consumer != null) {
                NCJMSQueueSession.trace("Closing the Message Consumer.");
                consumer.close();
            }
            NCJMSQueueSession.trace("Removing the Session from the Connection.");
            this.getConnection().removeSession(this);
        }
        finally {
            NCJMSQueueSession nCJMSQueueSession = this;
            synchronized (nCJMSQueueSession) {
                if (this.m_runningThread != null) {
                    this.m_runningThread.interrupt();
                }
            }
        }
        NCJMSQueueSession.trace("Session Closed.");
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = super.equals(obj);
        boolean bl = equal = equal && obj instanceof NCJMSQueueSession;
        if (equal) {
            NCJMSQueueSession other = (NCJMSQueueSession)obj;
            equal = equal && this.m_consumer != null ? this.m_consumer.equals(other.m_consumer) : other.m_consumer == null;
        }
        return equal;
    }

    public String toString() {
        String name = "QueueSession";
        try {
            if (this.m_consumer != null) {
                name = ((NCJMSQueueReceiver)this.m_consumer).getQueue().getQueueName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return name;
    }

    private static final void trace(String s) {
    }

    @Override
    public MessageConsumer createConsumer(Destination arg0, String arg1, boolean arg2) throws JMSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MessageConsumer createConsumer(Destination arg0, String arg1) throws JMSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MessageConsumer createConsumer(Destination arg0) throws JMSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MessageProducer createProducer(Destination arg0) throws JMSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unsubscribe(String arg0) throws JMSException {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean isStarted() {
        return this.m_hasStarted;
    }

    @Override
    void setStarted() {
        this.m_hasStarted = true;
    }

    @Override
    synchronized void notifySession() {
        this.notify();
    }
}

