/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jms.provider;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jms.provider.DestinationManager;
import com.cognos.jsmcommon.jms.provider.NCJMSConnection;
import com.cognos.jsmcommon.jms.provider.NCJMSQueue;
import com.cognos.jsmcommon.jms.provider.NCJMSQueueConnectionFactory;
import com.cognos.jsmcommon.jms.provider.Target;
import com.cognos.jsmcommon.jms.resource.JMSProperties;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.metrics.GlobalQueueMetricsMBean;
import com.cognos.jsmcommon.metrics.MetricsManager;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.ibm.cognos.jsmcommon.jms.JMSException;
import com.ibm.cognos.jsmcommon.jms.QueueConnectionFactory;
import javax.naming.NamingException;

public class NCJMSServer {
    private boolean _started = false;
    private static NCJMSServer _instance = new NCJMSServer();
    private QueueConnectionFactory queueConnectionFactory = null;

    private NCJMSServer() {
    }

    public static NCJMSServer instance() {
        return _instance;
    }

    public QueueConnectionFactory getQueueConnectionFactory() {
        return this.queueConnectionFactory;
    }

    public void setQueueConnectionFactory(QueueConnectionFactory queueConnectionFactory) {
        this.queueConnectionFactory = queueConnectionFactory;
    }

    public synchronized void initialise() {
        if (this._started) {
            return;
        }
        try {
            JMSProperties.getInstance().loadProperties();
            if (Boolean.valueOf(JMSProperties.getInstance().getProperty(JMSProperties.USE_NCJMS)).booleanValue()) {
                SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.INFO, I18NCode.MSG_CONTEXT_BINDING_START);
                this.bindNCJMS();
                SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.INFO, I18NCode.MSG_CONTEXT_BINDING_FINISHED);
                this._started = true;
            }
        }
        catch (Exception e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.FATAL, I18NCode.MSG_ERROR_BINDING_SERVICE);
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.GEN_3RD_PARTY_FAULT, new String[]{"" + e.getMessage()});
        }
    }

    private void bindNCJMS() throws NamingException {
        SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("Binding NC-JMS.");
        this.queueConnectionFactory = new NCJMSQueueConnectionFactory();
        String factory_name = JMSProperties.getInstance().getProperty(JMSProperties.FACTORY_NAME);
        SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.INFO, I18NCode.MSG_BINDING_FACTORY, new String[]{factory_name});
        this.bindQueue(JMSProperties.getInstance().getProperty(JMSProperties.EMAIL_QUEUE_NAME));
        this.bindQueue(JMSProperties.getInstance().getProperty(JMSProperties.EMAIL_BACKUP_QUEUE_NAME));
        this.bindQueue(JMSProperties.getInstance().getProperty(JMSProperties.JOB_QUEUE_NAME));
        SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("Finished binding NC-JMS.");
    }

    private void bindQueue(String name) throws NamingException {
        SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.INFO, I18NCode.MSG_BINDING_QUEUE, new String[]{name});
        NCJMSQueue queue = NCJMSConnection.createQueue(name);
        try {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("Registering Queue destination [" + name + "].");
            DestinationManager.getInstance().addDestination(new Target(queue));
            GlobalQueueMetricsMBean jmsQueueMetricsBean = queue.getMetricsBean();
            MetricsManager metricsManager = MetricsManager.getInstance();
            metricsManager.registerMBean(jmsQueueMetricsBean, queue.getQueueName(), "queue");
        }
        catch (JMSException e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.FATAL, I18NCode.MSG_ERROR_BINDING_SERVICE);
        }
    }
}

