/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jms.provider;

import com.cognos.jsmcommon.jms.provider.DestinationManager;
import com.cognos.jsmcommon.jms.provider.NCJMSConnection;
import com.cognos.jsmcommon.jms.provider.NCJMSObjectMessage;
import com.cognos.jsmcommon.jms.provider.NCJMSQueueConnection;
import com.ibm.cognos.jsmcommon.jms.BytesMessage;
import com.ibm.cognos.jsmcommon.jms.JMSException;
import com.ibm.cognos.jsmcommon.jms.Message;
import com.ibm.cognos.jsmcommon.jms.MessageListener;
import com.ibm.cognos.jsmcommon.jms.ObjectMessage;
import com.ibm.cognos.jsmcommon.jms.Session;
import java.io.Serializable;
import java.util.LinkedList;

public abstract class NCJMSSession
implements Session,
Runnable {
    protected NCJMSQueueConnection m_connection;
    int m_acknowledge_mode;
    private boolean m_transacted;
    private LinkedList m_unacknowledged = new LinkedList();
    private boolean m_closed;

    public NCJMSSession(NCJMSQueueConnection connection, boolean transacted, int acknowledge_mode) {
        this.m_connection = connection;
        this.m_transacted = transacted;
        this.m_acknowledge_mode = acknowledge_mode;
        this.m_closed = false;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        throw new JMSException("Session.createMessage() unsupported.");
    }

    @Override
    public Message createMessage() throws JMSException {
        throw new JMSException("Session.createMessage() unsupported.");
    }

    @Override
    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkClosed();
        return new NCJMSObjectMessage();
    }

    @Override
    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        this.checkClosed();
        return new NCJMSObjectMessage(object);
    }

    @Override
    public boolean getTransacted() throws JMSException {
        this.checkClosed();
        return this.m_transacted;
    }

    @Override
    public void commit() throws JMSException {
        throw new JMSException("Session.createQueue(..) unsupported.");
    }

    @Override
    public void rollback() throws JMSException {
        throw new JMSException("Session.commit() unsupported.");
    }

    @Override
    public void recover() throws JMSException {
        throw new JMSException("Session.recover() unsupported.");
    }

    @Override
    public MessageListener getMessageListener() throws JMSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMessageListener(MessageListener listener) throws JMSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getAcknowledgeMode() {
        return this.m_acknowledge_mode;
    }

    public synchronized void addUnacknowledged(Message message) {
        this.m_unacknowledged.add(message);
    }

    public LinkedList getUnacknowledged() {
        return this.m_unacknowledged;
    }

    public NCJMSConnection getConnection() {
        return this.m_connection;
    }

    synchronized boolean isClosed() {
        return this.m_closed;
    }

    synchronized void setClosed(boolean closed) {
        this.m_closed = closed;
    }

    void checkClosed() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException("The session is closed.");
        }
    }

    public synchronized void acknowledge(Message message) throws JMSException {
        LinkedList list = this.getUnacknowledged();
        int index = list.indexOf(message);
        DestinationManager dm = DestinationManager.getInstance();
        for (int i = 0; i <= index; ++i) {
            dm.acknowledge(message);
            Message message2 = (Message)list.removeFirst();
        }
    }

    public void send(Message message) throws JMSException {
        this.checkClosed();
        DestinationManager.getInstance().addMessage(message);
    }

    public boolean equals(Object obj) {
        boolean equal = obj instanceof NCJMSSession;
        if (equal) {
            NCJMSSession other = (NCJMSSession)obj;
            equal = equal && this.m_connection.equals(other.m_connection);
            equal = equal && this.m_transacted == other.m_transacted;
            equal = equal && this.m_unacknowledged.equals(other.m_unacknowledged);
            equal = equal && this.m_acknowledge_mode == other.m_acknowledge_mode;
            equal = equal && this.m_closed == other.m_closed;
        }
        return equal;
    }

    abstract boolean isStarted();

    abstract void setStarted();

    abstract void notifySession();
}

