/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jms.provider;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.jdbc.props.DatabaseType;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import com.cognos.jsmcommon.jms.provider.JMSQueueEntry;
import com.cognos.jsmcommon.jms.provider.NCJMSObjectMessage;
import com.cognos.jsmcommon.jms.provider.NCJMSQueue;
import com.cognos.jsmcommon.jms.provider.PersistedOracleJMSQueue;
import com.cognos.jsmcommon.jms.resource.JMSProperties;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.objectid.NCObjectIdUtil;
import com.cognos.jsmcommon.property.CMProperties;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.serverinst.InstanceFailedEvent;
import com.cognos.jsmcommon.serverinst.SDSInstance;
import com.cognos.jsmcommon.serverinst.SDSInstanceListener;
import com.cognos.jsmcommon.serverinst.SDSInstanceManager;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.ZipUtils;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.ibm.cognos.jsmcommon.jms.JMSException;
import com.ibm.cognos.jsmcommon.jms.Message;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public class PersistedJMSQueue
implements SDSInstanceListener {
    private static int DEFAULT_REDELIVER_DELAY = 3600;
    private static String m_serverInst;
    protected static final String ID_PROP_KEY = "ObjectID";
    protected static final String QUEUE_PROP_KEY = "QueueName";
    private static Map m_queueMap;
    private NCJMSQueue m_queue = null;
    protected static final String JDBC_TABLE = "NC_JMSQUEUE";
    protected static final String F_QUEUE_ENTRY_ID = "QUEUE_ENTRY_ID";
    protected static final String F_QUEUE_NAME = "QUEUE_NAME";
    protected static final String F_QUEUE_ENTRY = "QUEUE_ENTRY";
    protected static final String F_INSTANCE = "SDS_INSTANCE_ID";
    protected static final String F_DATE = "DATE_ENTERED";
    private static final String F_REDELIVER_DATE = "REDELIVER_DATE";
    private static final String F_REDELIVER_COUNT = "REDELIVER_COUNT";
    protected static final String SELECT_QUEUE_ENTRY_SQL = "SELECT QUEUE_ENTRY_ID, QUEUE_NAME, QUEUE_ENTRY, SDS_INSTANCE_ID, DATE_ENTERED, REDELIVER_DATE, REDELIVER_COUNT FROM NC_JMSQUEUE WHERE QUEUE_ENTRY_ID = ? ";
    private static final String INSERT_SQL = "INSERT INTO NC_JMSQUEUE (QUEUE_ENTRY_ID, QUEUE_NAME, QUEUE_ENTRY, DATE_ENTERED)  VALUES (?,?,?,?)";
    private static final String SELECT_NEXT_MESSAGE_SQL = "SELECT QUEUE_ENTRY_ID, QUEUE_NAME,QUEUE_ENTRY,SDS_INSTANCE_ID,DATE_ENTERED FROM NC_JMSQUEUE WHERE QUEUE_NAME = ? AND DATE_ENTERED <= ?  AND SDS_INSTANCE_ID IS NULL";
    private static final String UPDATE_INSTANCE_SQL = "UPDATE NC_JMSQUEUE SET SDS_INSTANCE_ID = ?  WHERE QUEUE_ENTRY_ID = ? AND SDS_INSTANCE_ID IS NULL";
    private static final String SELECT_NEXT_INSTANCE_SQL = "SELECT QUEUE_ENTRY_ID, QUEUE_NAME,QUEUE_ENTRY,SDS_INSTANCE_ID,DATE_ENTERED FROM NC_JMSQUEUE WHERE QUEUE_NAME = ? AND SDS_INSTANCE_ID = ?";
    private static final String SELECT_NEXT_MESSAGE_ALL_SQL = "SELECT QUEUE_ENTRY_ID, QUEUE_NAME, QUEUE_ENTRY, SDS_INSTANCE_ID, DATE_ENTERED, REDELIVER_DATE, REDELIVER_COUNT FROM NC_JMSQUEUE WHERE QUEUE_NAME = ? AND DATE_ENTERED <= ? AND SDS_INSTANCE_ID IS NULL AND (REDELIVER_DATE IS NULL OR REDELIVER_DATE <= ? )";
    private static final String SELECT__MESSAGES_ALL_SQL = "SELECT QUEUE_ENTRY_ID, QUEUE_NAME, QUEUE_ENTRY, SDS_INSTANCE_ID, DATE_ENTERED, REDELIVER_DATE, REDELIVER_COUNT FROM NC_JMSQUEUE WHERE QUEUE_NAME = ? AND SDS_INSTANCE_ID IS NULL";
    private static final String COUNT_SQL = "SELECT COUNT(*) FROM NC_JMSQUEUE WHERE QUEUE_NAME=? AND SDS_INSTANCE_ID IS NULL";
    private static final String DELETE_ENTRY_SQL = "DELETE FROM NC_JMSQUEUE WHERE QUEUE_ENTRY_ID = ?";
    private static final String RECOVER_MESSAGE_SQL = "UPDATE NC_JMSQUEUE SET SDS_INSTANCE_ID = NULL, REDELIVER_DATE = ?, REDELIVER_COUNT = REDELIVER_COUNT + 1  WHERE QUEUE_ENTRY_ID = ? AND SDS_INSTANCE_ID IS NOT NULL";
    private static final String CLEANUP_SQL = "UPDATE NC_JMSQUEUE SET SDS_INSTANCE_ID = NULL WHERE SDS_INSTANCE_ID = ?";
    private static final String BLOB_SELECT = "SELECT QUEUE_ENTRY FROM NC_JMSQUEUE WHERE QUEUE_ENTRY_ID = ? ";
    private Map m_transactionConnections = new HashMap();
    private Long m_pollInterval = new Long(30000L);
    private QueuePollingThread m_queuePollingThread;

    public static synchronized PersistedJMSQueue instance(NCJMSQueue queue) {
        PersistedJMSQueue jmsQueue = (PersistedJMSQueue)m_queueMap.get(queue);
        if (jmsQueue == null) {
            DatabaseType dbType = JDBCConnectionProperties.instance("SDS").getDBType();
            jmsQueue = DatabaseType.ORACLE.equals(dbType) ? new PersistedOracleJMSQueue(queue) : new PersistedJMSQueue(queue);
            m_queueMap.put(queue, jmsQueue);
        }
        return jmsQueue;
    }

    protected PersistedJMSQueue(NCJMSQueue queue) {
        m_serverInst = SDSInstanceManager.getInstance().getThisInstance().getGuid();
        SDSInstanceManager.getInstance().addInstanceListener(this);
        this.m_queue = queue;
    }

    public synchronized void start(Object notifyObject) {
        if (this.m_queuePollingThread == null) {
            String name = this.m_queue.getQueueName();
            this.m_queuePollingThread = new QueuePollingThread(name, notifyObject);
            this.m_queuePollingThread.setDaemon(true);
            this.m_queuePollingThread.start();
        }
        SDSInstanceManager.getInstance().addInstanceListener(this);
    }

    public void stop() {
        SDSInstanceManager.getInstance().removeInstanceListener(this);
    }

    public Long getPollInterval() {
        if (this.m_pollInterval == null) {
            return new Long(30000L);
        }
        return this.m_pollInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCountPending() {
        ResultSet rs;
        PreparedStatement ps;
        JDBCConnection conn;
        int size;
        block4: {
            size = -1;
            conn = null;
            ps = null;
            rs = null;
            try {
                conn = this.getConnection(true);
                ps = conn.prepareStatement(COUNT_SQL);
                ps.setString(1, this.m_queue.getQueueName());
                rs = ps.executeQuery();
                if (!rs.next()) break block4;
                size = rs.getInt(1);
            }
            catch (SQLException e) {
                try {
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
                }
                catch (Throwable throwable) {
                    SqlResourceCloser.closeResources(rs, ps);
                    this.releaseConnection(conn);
                    throw throwable;
                }
                SqlResourceCloser.closeResources(rs, ps);
                this.releaseConnection(conn);
            }
        }
        SqlResourceCloser.closeResources(rs, ps);
        this.releaseConnection(conn);
        return size;
    }

    public void add(Message message) throws JMSException {
        this.persistMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover(Message message) throws JMSException {
        String idStr = message.getStringProperty(ID_PROP_KEY);
        NCObjectId id = NCObjectId.valueOf(idStr);
        double delay = CRNProperties.getInstance().getIntProperty(JMSProperties.RECOVER_DELAY_NAME.getKey(), DEFAULT_REDELIVER_DELAY);
        try {
            delay = Double.valueOf(message.getStringProperty(JMSProperties.RECOVER_DELAY_NAME.getKey()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        long redeliverDate = new Date().getTime();
        if (delay > 0.0) {
            redeliverDate = (long)((double)redeliverDate + delay * 1000.0);
        }
        JDBCConnection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(false);
            ps = conn.prepareStatement(RECOVER_MESSAGE_SQL);
            ps.setLong(1, redeliverDate);
            NCObjectId.setIntoStatement(id, 2, ps);
            ps.executeUpdate();
            this.closeStatement(ps);
            this.releaseConnection(conn);
        }
        catch (SQLException e) {
            try {
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_UNABLE_RECOVER_DB);
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
                this.checkTransactionError();
                this.closeStatement(ps);
                this.releaseConnection(conn);
            }
            catch (Throwable throwable) {
                this.closeStatement(ps);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
    }

    public void delete(Message message) throws JMSException {
        String idStr = message.getStringProperty(ID_PROP_KEY);
        NCObjectId id = NCObjectId.valueOf(idStr);
        this.delete(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete(NCObjectId id) {
        if (id == null) {
            return;
        }
        JDBCConnection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(false);
            ps = conn.prepareStatement(DELETE_ENTRY_SQL);
            NCObjectId.setIntoStatement(id, 1, ps);
            ps.executeUpdate();
            this.closeStatement(ps);
            this.releaseConnection(conn);
        }
        catch (SQLException e) {
            try {
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_UNABLE_DELETE_DB);
                this.checkTransactionError();
                this.closeStatement(ps);
                this.releaseConnection(conn);
            }
            catch (Throwable throwable) {
                this.closeStatement(ps);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message removeFirst() throws JMSException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("PersistedJMSQueue.removeFirst");
        try {
            Message message = this.doRemoveFirst();
            if (message != null && this.m_queue.getMetrics().tideMetricsActive()) {
                this.m_queue.getMetrics().updateQueueLengthLowWaterMark(this.getCountPending());
                long timeInQueue = new Date().getTime() - message.getJMSTimestamp();
                this.m_queue.getMetrics().updateTimeInQueueLowWaterMark(timeInQueue);
                this.m_queue.getMetrics().updateTimeInQueueHighWaterMark(timeInQueue);
                this.m_queue.getMetrics().incrementTimeInQueue(timeInQueue);
                this.m_queue.getMetrics().incrementNumberOfRequests(1L);
            }
            Message message2 = message;
            return message2;
        }
        finally {
            zipiTimer.stop();
        }
    }

    public Enumeration getEnumeration() throws JMSException {
        Enumeration enumeration;
        Vector<Message> messages = new Vector<Message>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        JDBCConnection connection = null;
        JMSQueueEntry jmsQueueEntry = null;
        Message message = null;
        try {
            connection = this.getConnection(true);
            ps = connection.prepareStatement(SELECT__MESSAGES_ALL_SQL);
            ps.setString(1, this.m_queue.getQueueName());
            ps.setMaxRows(10000);
            rs = ps.executeQuery();
            while (rs.next()) {
                jmsQueueEntry = this.readRS(connection, rs);
                if (jmsQueueEntry != null) {
                    message = jmsQueueEntry.getMessage();
                }
                messages.add(message);
            }
            enumeration = messages.elements();
        }
        catch (SQLException e) {
            try {
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_SELECT_SQL_ERROR, new String[]{e.getMessage()});
                throw new JMSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SqlResourceCloser.closeResources(rs, ps);
                this.releaseConnection(connection);
                throw throwable;
            }
        }
        SqlResourceCloser.closeResources(rs, ps);
        this.releaseConnection(connection);
        return enumeration;
    }

    protected JDBCConnection getConnection(boolean readonlyIsRequired) throws SQLException {
        Object tcObj = this.m_transactionConnections.get(Thread.currentThread());
        JDBCConnection connection = null;
        connection = tcObj == null ? (readonlyIsRequired ? NCConnection.instance().getConnectionFactory().createReadOnlyConnection() : NCConnection.instance().getConnectionFactory().createConnection()) : ((TransactionConnection)tcObj).getTransactionConnection();
        connection.setTransactionIsolation(2);
        return connection;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void persistMessage(Message message) throws JMSException {
        JDBCConnection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(false);
            ps = conn.prepareStatement(INSERT_SQL);
            NCObjectId id = NCObjectId.createNew();
            message.setStringProperty(ID_PROP_KEY, id.toString());
            NCObjectId.setIntoStatement(id, 1, ps);
            message.setStringProperty(QUEUE_PROP_KEY, this.m_queue.getQueueName());
            ps.setString(2, this.m_queue.getQueueName());
            byte[] bytes = ZipUtils.writeObjectToBytes(message);
            ps.setBinaryStream(3, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
            ps.setLong(4, new Date().getTime());
            ps.executeUpdate();
            conn.commit();
            if (this.m_queue.getMetrics().tideMetricsActive()) {
                this.m_queue.getMetrics().updateQueueLengthHighWaterMark(this.getCountPending());
            }
        }
        catch (SQLException e) {
            try {
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_UNABLE_PERSIST_DB);
                this.checkTransactionError();
                throw new JMSException(e.getMessage());
                catch (IOException e2) {
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e2);
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_UNABLE_PREPARE_MESSAGE);
                    this.checkTransactionError();
                    throw new JMSException(e2.getMessage());
                }
                catch (JMSException e3) {
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e3);
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_UNABLE_PREPARE_MESSAGE);
                    this.checkTransactionError();
                    throw e3;
                }
                catch (Throwable e4) {
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e4);
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_UNABLE_PREPARE_MESSAGE);
                    this.checkTransactionError();
                    throw new JMSException(e4.getLocalizedMessage());
                }
            }
            catch (Throwable throwable) {
                SqlResourceCloser.closeResources(rs, ps);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        SqlResourceCloser.closeResources(rs, ps);
        this.releaseConnection(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message getEntry(NCObjectId id) {
        JDBCConnection connection;
        ResultSet rs;
        PreparedStatement ps;
        Message message;
        block4: {
            message = null;
            ps = null;
            rs = null;
            connection = null;
            JMSQueueEntry jmsQueueEntry = null;
            try {
                connection = this.getConnection(true);
                ps = connection.prepareStatement(SELECT_QUEUE_ENTRY_SQL);
                NCObjectIdUtil.instance().setIntoStatement(id, 1, ps);
                ps.setMaxRows(1);
                rs = ps.executeQuery();
                jmsQueueEntry = this.readRS(connection, rs);
                if (jmsQueueEntry == null) break block4;
                message = jmsQueueEntry.getMessage();
            }
            catch (SQLException e) {
                try {
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_SELECT_SQL_ERROR);
                }
                catch (Throwable throwable) {
                    SqlResourceCloser.closeResources(rs, ps);
                    this.releaseConnection(connection);
                    throw throwable;
                }
                SqlResourceCloser.closeResources(rs, ps);
                this.releaseConnection(connection);
            }
        }
        SqlResourceCloser.closeResources(rs, ps);
        this.releaseConnection(connection);
        return message;
    }

    private Message doRemoveFirst() throws JMSException {
        JMSQueueEntry qEntry = null;
        this.beginTransaction();
        JDBCConnection connection = null;
        try {
            connection = this.getConnection(false);
            qEntry = this.doReadNext(connection);
            boolean updated = false;
            while (qEntry != null && !updated) {
                if (qEntry.getMessage() == null) {
                    qEntry = this.doReadNext(connection);
                    continue;
                }
                updated = this.doUpdate(connection, qEntry.getMessage());
                if (updated) continue;
                qEntry = this.doReadNext(connection);
            }
        }
        catch (SQLException e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_UNABLE_LOAD_DQ_MESSAGE);
            throw new JMSException(I18NUtil.getMessage(I18NCode.MSG_UNABLE_LOAD_DQ_MESSAGE, Locale.getDefault()));
        }
        finally {
            this.endTransaction();
        }
        return qEntry == null ? null : qEntry.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMSQueueEntry doReadNext(Connection connection) {
        JMSQueueEntry qEntry;
        ResultSet rs;
        PreparedStatement ps;
        block5: {
            ps = null;
            rs = null;
            SQLException exception = null;
            qEntry = null;
            Date now = new Date();
            try {
                ps = connection.prepareStatement(SELECT_NEXT_MESSAGE_ALL_SQL);
                ps.setString(1, this.m_queue.getQueueName());
                ps.setLong(2, now.getTime());
                ps.setLong(3, now.getTime());
                ps.setMaxRows(1);
                rs = ps.executeQuery();
                qEntry = this.readRS(connection, rs);
                if (exception == null) break block5;
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(exception);
            }
            catch (SQLException e) {
                block6: {
                    try {
                        exception = e;
                        if (exception == null) break block6;
                        SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(exception);
                    }
                    catch (Throwable throwable) {
                        if (exception != null) {
                            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(exception);
                            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_SELECT_SQL_ERROR, new String[]{exception.getMessage()});
                            this.checkTransactionError();
                        }
                        SqlResourceCloser.closeResources(rs, ps);
                        throw throwable;
                    }
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_SELECT_SQL_ERROR, new String[]{exception.getMessage()});
                    this.checkTransactionError();
                }
                SqlResourceCloser.closeResources(rs, ps);
            }
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_SELECT_SQL_ERROR, new String[]{exception.getMessage()});
            this.checkTransactionError();
        }
        SqlResourceCloser.closeResources(rs, ps);
        return qEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean doUpdate(Connection conn, Message message) throws SQLException {
        boolean updated = false;
        PreparedStatement ps = null;
        try {
            String idStr = message.getStringProperty(ID_PROP_KEY);
            NCObjectId id = NCObjectId.valueOf(idStr);
            ps = conn.prepareStatement(UPDATE_INSTANCE_SQL);
            ps.setString(1, m_serverInst);
            NCObjectIdUtil.instance().setIntoStatement(id, 2, ps);
            int result = ps.executeUpdate();
            updated = result == 1;
            this.closeStatement(ps);
        }
        catch (JMSException e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_UPDATE_SQL_ERROR, new String[]{e.getMessage()});
            this.closeStatement(ps);
        }
        catch (SQLException e2) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e2);
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_UPDATE_SQL_ERROR, new String[]{e2.getMessage()});
            this.closeStatement(ps);
            {
                catch (Throwable throwable) {
                    this.closeStatement(ps);
                    throw throwable;
                }
            }
        }
        return updated;
    }

    protected void beginTransaction() throws JMSException {
        try {
            Thread currentThread = Thread.currentThread();
            TransactionConnection connection = new TransactionConnection();
            this.m_transactionConnections.put(currentThread, connection);
        }
        catch (SQLException ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(ex);
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_COULD_NOT_INIT_CONNECTIONS, new Object[]{"JMS SQL"});
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new JMSException(ex.getMessage());
        }
    }

    public void endTransaction() throws JMSException {
        try {
            Thread currentThread = Thread.currentThread();
            Object tcObj = this.m_transactionConnections.remove(currentThread);
            if (tcObj == null) {
                throw new JMSException("Unable to release transacted connection.");
            }
            ((TransactionConnection)tcObj).endTransaction();
        }
        catch (SQLException ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(ex);
            throw new JMSException("SQL Error when releasing transaction connection: " + ex.getMessage());
        }
    }

    protected void checkTransactionError() {
        Thread currentThread = Thread.currentThread();
        Object tcObj = this.m_transactionConnections.get(currentThread);
        if (tcObj != null) {
            ((TransactionConnection)tcObj).transactionError();
        }
    }

    protected void closeStatement(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(ex);
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_CLOSE_SQL_ERROR, new Object[]{ex.getMessage()});
        }
    }

    protected void releaseConnection(JDBCConnection conn) {
        Thread currentThread = Thread.currentThread();
        Object tcObj = this.m_transactionConnections.get(currentThread);
        if (tcObj == null) {
            SqlResourceCloser.releaseConnection(conn);
        }
    }

    protected JMSQueueEntry buildQueueEntry(ResultSet rs, Message message) throws SQLException {
        NCObjectId currentId = NCObjectIdUtil.instance().createObjectId(rs, F_QUEUE_ENTRY_ID);
        String sQueueName = rs.getString(F_QUEUE_NAME);
        String sSdsInstanceId = rs.getString(F_INSTANCE);
        long lDateEntered = rs.getLong(F_DATE);
        Date dDateEntered = new Date(lDateEntered);
        JMSQueueEntry jmsQueueEntry = new JMSQueueEntry(message, currentId, sSdsInstanceId, dDateEntered, sQueueName);
        return jmsQueueEntry;
    }

    protected InputStream getQueueEntryInputStream(ResultSet rs) throws SQLException {
        return rs.getBinaryStream(F_QUEUE_ENTRY);
    }

    protected JMSQueueEntry readRS(Connection conn, ResultSet rs) {
        NCObjectId currentId;
        boolean errorOccurred;
        JMSQueueEntry jmsQueueEntry;
        block13: {
            Message message = null;
            jmsQueueEntry = null;
            errorOccurred = false;
            currentId = null;
            try {
                if (rs == null || !rs.next()) break block13;
                try {
                    currentId = null;
                    currentId = NCObjectIdUtil.instance().createObjectId(rs, F_QUEUE_ENTRY_ID);
                    jmsQueueEntry = this.buildQueueEntry(rs, null);
                    InputStream is = this.getQueueEntryInputStream(rs);
                    if (is == null) {
                        errorOccurred = true;
                        break block13;
                    }
                    ObjectInputStream ois = new ObjectInputStream(is);
                    message = (Message)ois.readObject();
                    ois.close();
                    rs.getLong(F_REDELIVER_DATE);
                    if (!rs.wasNull()) {
                        message.setJMSRedelivered(true);
                    }
                    int redeliveredCount = rs.getInt(F_REDELIVER_COUNT);
                    message.setIntProperty("redelivered.count", redeliveredCount);
                    message.setJMSDestination(this.m_queue);
                    jmsQueueEntry.setMessage(message);
                }
                catch (StreamCorruptedException e) {
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_SELECT_SQL_ERROR, new String[]{e.getClass().getName() + e.getMessage()});
                    errorOccurred = true;
                }
                catch (OptionalDataException e) {
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_SELECT_SQL_ERROR, new String[]{e.getClass().getName() + e.getMessage()});
                    errorOccurred = true;
                }
                catch (InvalidClassException e) {
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_SELECT_SQL_ERROR, new String[]{e.getClass().getName() + e.getMessage()});
                    errorOccurred = true;
                }
                catch (ClassNotFoundException e) {
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_SELECT_SQL_ERROR, new String[]{e.getClass().getName() + e.getMessage()});
                    errorOccurred = true;
                }
                catch (ClassCastException e) {
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_SELECT_SQL_ERROR, new String[]{e.getClass().getName() + e.getMessage()});
                    errorOccurred = true;
                }
                catch (Throwable e) {
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_SELECT_SQL_ERROR, new String[]{e.getClass().getName() + e.getMessage()});
                    errorOccurred = true;
                }
            }
            catch (SQLException e) {
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_SELECT_SQL_ERROR, new String[]{e.getMessage()});
            }
        }
        if (errorOccurred) {
            if (jmsQueueEntry != null) {
                jmsQueueEntry.logEmptyQueueEntry();
            }
            this.delete(currentId);
        }
        return jmsQueueEntry;
    }

    protected void removeWaitingThread() {
        if (this.m_queuePollingThread != null) {
            this.m_queuePollingThread.removeWaitingThread();
        }
    }

    protected void addWaitingThread() {
        if (this.m_queuePollingThread != null) {
            this.m_queuePollingThread.addWaitingThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void instanceFailed(InstanceFailedEvent event) {
        this.cleanUp(event.getFailedInstance().getGuid());
        Iterator queueItr = m_queueMap.keySet().iterator();
        while (queueItr.hasNext()) {
            Object queue;
            Object k = queue = queueItr.next();
            synchronized (k) {
                queue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int cleanUp(String guid) {
        int count = 0;
        NCJMSQueue nCJMSQueue = this.m_queue;
        synchronized (nCJMSQueue) {
            JDBCConnection conn = null;
            PreparedStatement ps = null;
            try {
                conn = this.getConnection(false);
                ps = conn.prepareStatement(CLEANUP_SQL);
                ps.setString(1, guid);
                count = ps.executeUpdate();
                this.closeStatement(ps);
                this.releaseConnection(conn);
            }
            catch (SQLException e) {
                try {
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_PERSISTABLE_SCHEDULER_QUEUE_UPDATE_SQL_ERROR, new String[]{e.getMessage()});
                    this.closeStatement(ps);
                    this.releaseConnection(conn);
                }
                catch (Throwable throwable) {
                    this.closeStatement(ps);
                    this.releaseConnection(conn);
                    throw throwable;
                }
            }
        }
        return count;
    }

    protected NCJMSQueue getQueue() {
        return this.m_queue;
    }

    protected static String getServerInst() {
        return m_serverInst;
    }

    public int hashCode() {
        return m_serverInst.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof PersistedJMSQueue;
    }

    private static Message getMessage() throws Exception {
        NCJMSObjectMessage jms = new NCJMSObjectMessage();
        byte[] bytes = new byte[4012];
        Arrays.fill(bytes, (byte)1);
        return jms;
    }

    private static JDBCConnection getTestConnection() throws Exception {
        JDBCConnectionProperties props = PersistedJMSQueue.getConnectionDetails("Microsoft", "test", "localhost", "nc_user2", "nc_user2");
        return NCConnection.instance().getConnectionFactory().createConnection();
    }

    public static JDBCConnectionProperties getConnectionDetails(String db, String name, String server, String user, String pwd) throws Exception {
        CMProperties cmProps = CMProperties.getInstance();
        cmProps.setProperty("databaseType", db);
        cmProps.setProperty("name", name);
        cmProps.setProperty("servicename", name);
        cmProps.setProperty("server", server);
        cmProps.setProperty("username", user);
        cmProps.setProperty("password", pwd);
        NCConnection.resetInstance();
        JDBCConnectionProperties.resetInstance();
        JDBCConnectionProperties jdbcProps = JDBCConnectionProperties.testInstance(cmProps);
        NCConnection.enforcedInstance();
        return jdbcProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        JDBCConnection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Message message = PersistedJMSQueue.getMessage();
            conn = PersistedJMSQueue.getTestConnection();
            ps = conn.prepareStatement(INSERT_SQL);
            NCObjectId id = NCObjectId.createNew();
            message.setStringProperty(ID_PROP_KEY, id.toString());
            NCObjectId.setIntoStatement(id, 1, ps);
            message.setStringProperty(QUEUE_PROP_KEY, "test");
            ps.setString(2, "test");
            ps.setBinaryStream(3, (InputStream)new ByteArrayInputStream(new byte[]{0, 0, 0}), 2);
            ps.setLong(4, new Date().getTime());
            ps.executeUpdate();
            SqlResourceCloser.closeResources(null, ps);
            ps = conn.prepareStatement("SELECT QUEUE_ENTRY FROM NC_JMSQUEUE WHERE QUEUE_ENTRY_ID = ?");
            NCObjectId.setIntoStatement(id, 1, ps);
            rs = ps.executeQuery();
            rs.next();
            Blob blob = rs.getBlob(F_QUEUE_ENTRY);
            if (blob.length() != 3L) {
                throw new Exception("rubbish");
            }
            conn.commit();
        }
        catch (Throwable e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                SqlResourceCloser.closeResources(rs, ps);
                SqlResourceCloser.releaseConnection(conn);
                throw throwable;
            }
            SqlResourceCloser.closeResources(rs, ps);
            SqlResourceCloser.releaseConnection(conn);
        }
        SqlResourceCloser.closeResources(rs, ps);
        SqlResourceCloser.releaseConnection(conn);
    }

    @Override
    public void otherInstanceCountChanged(List<SDSInstance> instances) {
    }

    static {
        m_queueMap = new HashMap();
    }

    private class TransactionConnection {
        private JDBCConnection m_transactionConnection;
        private boolean m_transactionError;

        public TransactionConnection() throws SQLException {
            this.m_transactionConnection = PersistedJMSQueue.this.getConnection(false);
            this.m_transactionConnection.setAutoCommit(false);
        }

        public void transactionError() {
            this.m_transactionError = true;
        }

        public JDBCConnection getTransactionConnection() {
            return this.m_transactionConnection;
        }

        public void endTransaction() throws SQLException {
            try {
                if (this.m_transactionError) {
                    this.m_transactionConnection.rollback();
                } else {
                    this.m_transactionConnection.commit();
                }
            }
            finally {
                SqlResourceCloser.releaseConnection(this.m_transactionConnection);
                this.m_transactionConnection = null;
            }
        }
    }

    private class QueuePollingThread
    extends Thread {
        private boolean m_isEnabled;
        private List m_waitingThreads;
        private Object m_waitOn;

        QueuePollingThread(String queueName, Object notifyObject) {
            super("JSM." + queueName + ".Polling");
            this.m_isEnabled = true;
            this.m_waitingThreads = new ArrayList();
            this.m_waitOn = null;
            this.m_waitOn = notifyObject;
        }

        synchronized void addWaitingThread() {
            if (!this.m_isEnabled) {
                return;
            }
            this.m_waitingThreads.add(Thread.currentThread());
            this.notify();
        }

        synchronized void removeWaitingThread() {
            if (!this.m_isEnabled) {
                return;
            }
            this.m_waitingThreads.remove(Thread.currentThread());
            this.notify();
        }

        synchronized int getWaitingThreadsCount() {
            return this.m_waitingThreads.size();
        }

        synchronized void terminate() {
            this.m_isEnabled = false;
            this.interrupt();
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.m_isEnabled) {
                try {
                    Object object;
                    if (this.getWaitingThreadsCount() > 0) {
                        Thread.sleep(PersistedJMSQueue.this.getPollInterval());
                        object = this.m_waitOn;
                        synchronized (object) {
                            int size;
                            ZipiTimer zipiTimer = ZipiBridge.startTimer("PersistedJMSQueue.run.getCountPending");
                            try {
                                size = PersistedJMSQueue.this.getCountPending();
                            }
                            finally {
                                zipiTimer.stopAndClear();
                            }
                            if (size > 0) {
                                this.m_waitOn.notifyAll();
                            }
                            continue;
                        }
                    }
                    object = this;
                    synchronized (object) {
                        if (this.getWaitingThreadsCount() == 0) {
                            this.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Throwable throwable) {
                }
            }
        }
    }
}

