/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jms.provider;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.util.JDBCBlobUtilOracleImpl;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import com.cognos.jsmcommon.jms.provider.NCJMSQueue;
import com.cognos.jsmcommon.jms.provider.PersistedJMSQueue;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.ibm.cognos.jsmcommon.jms.JMSException;
import com.ibm.cognos.jsmcommon.jms.Message;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

public class PersistedOracleJMSQueue
extends PersistedJMSQueue {
    private static final String INSERT_SQL = "INSERT INTO NC_JMSQUEUE (QUEUE_ENTRY_ID, QUEUE_NAME, QUEUE_ENTRY, DATE_ENTERED)  VALUES (?,?,EMPTY_BLOB(),?)";
    private static final String BLOB_SELECT = "SELECT QUEUE_ENTRY FROM NC_JMSQUEUE WHERE QUEUE_ENTRY_ID = ?  FOR UPDATE";

    PersistedOracleJMSQueue(NCJMSQueue queue) {
        super(queue);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void persistMessage(Message message) throws JMSException {
        JDBCConnection conn = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            this.beginTransaction();
            conn = this.getConnection(false);
            ps = conn.prepareStatement(INSERT_SQL);
            NCObjectId id2333332 = NCObjectId.createNew();
            message.setStringProperty("ObjectID", id2333332.toString());
            NCObjectId.setIntoStatement(id2333332, 1, ps);
            message.setStringProperty("QueueName", this.getQueue().getQueueName());
            ps.setString(2, this.getQueue().getQueueName());
            ps.setLong(3, new Date().getTime());
            ps.executeUpdate();
            this.closeStatement(ps);
            ps = null;
            ps = conn.prepareStatement(BLOB_SELECT);
            NCObjectId.setIntoStatement(id2333332, 1, ps);
            rs = ps.executeQuery();
            JDBCBlobUtilOracleImpl util = new JDBCBlobUtilOracleImpl();
            util.updateBlob(rs, message);
            this.getQueue().getMetrics().updateQueueLengthHighWaterMark(this.getCountPending());
        }
        catch (SQLException e) {
            try {
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e);
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_UNABLE_PERSIST_DB);
                this.checkTransactionError();
                throw new JMSException(e.getMessage());
                catch (JMSException e2) {
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(e2);
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, I18NCode.MSG_UNABLE_PREPARE_MESSAGE);
                    this.checkTransactionError();
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (oos != null) {
                        oos.close();
                    }
                    if (baos != null) {
                        baos.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SqlResourceCloser.closeResources(rs, ps);
                this.endTransaction();
                throw throwable;
            }
        }
        try {
            if (oos != null) {
                oos.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
        catch (Exception id2333332) {
            // empty catch block
        }
        SqlResourceCloser.closeResources(rs, ps);
        this.endTransaction();
    }

    @Override
    protected InputStream getQueueEntryInputStream(ResultSet rs) throws SQLException {
        Blob blob = rs.getBlob("QUEUE_ENTRY");
        return blob == null ? null : blob.getBinaryStream();
    }
}

