/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jms.provider;

import com.cognos.jsmcommon.util.TempFilesUtil;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Trace {
    public static final String DIR_NAME = "jms-trace";
    public static final String FILENAME = "trace.txt";
    public static final String SEPARATOR = "\t";
    public static final String CRLF = "\r\n";
    private static PrintStream[] m_streams;
    public static final boolean ON = false;
    private static final boolean LOG_CALLER = false;
    private static final boolean LOG_THREAD = true;
    private static final boolean LOG_TIME = false;
    private static final boolean TO_STDOUT = true;
    private static final boolean TO_FILE = true;
    private static boolean m_initialised;

    public static synchronized void log(String log) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Thread.currentThread().getName() + SEPARATOR);
        buffer.append(SEPARATOR);
        buffer.append(SEPARATOR);
        buffer.append(log + CRLF);
        String message = buffer.toString();
        Trace.initStreams();
        for (int i = 0; i < m_streams.length; ++i) {
            m_streams[i].print(message);
        }
    }

    public static synchronized void log(Exception e) {
        Trace.log("Exception : " + e.getMessage());
    }

    private static final String getCaller(int callerNumber) {
        if (callerNumber < 1) {
            return "Trace";
        }
        int tokenNumber = callerNumber * 2 + 3;
        CharArrayWriter stream = new CharArrayWriter();
        Throwable throwable = new Throwable();
        throwable.printStackTrace(new PrintWriter(stream));
        StringTokenizer stackTrace = new StringTokenizer(stream.toString());
        String token = "";
        try {
            for (int i = 0; i < tokenNumber; ++i) {
                token = stackTrace.nextToken();
            }
        }
        catch (NoSuchElementException ignored) {
            token = "unknown";
        }
        String pakage = "com.cognos.jsmcommon.jms.provider.";
        int index = token.indexOf(pakage);
        if (index != -1) {
            token = token.substring(index + pakage.length());
        }
        return token;
    }

    private static final void initStreams() {
        if (m_initialised) {
            return;
        }
        ArrayList<PrintStream> streams = new ArrayList<PrintStream>();
        try {
            streams.add(System.out);
            File trace_dir = TempFilesUtil.getStorageRootDir(DIR_NAME);
            File[] olds = trace_dir.listFiles();
            for (int i = 0; i < olds.length; ++i) {
                olds[i].delete();
            }
            File trace = new File(trace_dir, FILENAME);
            FileOutputStream fos = new FileOutputStream(trace);
            streams.add(new PrintStream(fos));
        }
        catch (Throwable e) {
            System.out.println("EEK : " + e.getMessage());
        }
        m_streams = streams.toArray(new PrintStream[streams.size()]);
        m_initialised = true;
    }

    static {
        m_initialised = false;
    }
}

