/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.jms.resource;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.property.PropertiesException;
import java.util.Properties;

public class JMSProperties {
    public static final JMSProperty FACTORY_NAME = new JMSProperty("jms.factory.name");
    public static final JMSProperty EMAIL_QUEUE_NAME = new JMSProperty("jms.email.queue.name");
    public static final JMSProperty EMAIL_BACKUP_QUEUE_NAME = new JMSProperty("jms.email.backup.queue.name");
    public static final JMSProperty USE_NCJMS = new JMSProperty("use.ncjms");
    public static final JMSProperty HTTP_QUEUE_NAME = new JMSProperty("jms.http.queue.name");
    public static final JMSProperty JOB_QUEUE_NAME = new JMSProperty("jms.job.queue.name");
    public static final JMSProperty RECOVER_DELAY_NAME = new JMSProperty("smtp.redelivery.delay");
    public static final String REDELIVERED_COUNT = "redelivered.count";
    private static JMSProperties m_instance = new JMSProperties();
    private Properties m_props;

    JMSProperties() {
    }

    public synchronized void loadProperties() throws PropertiesException {
        try {
            if (this.m_props == null) {
                this.m_props = new Properties();
                this.m_props.load(this.getClass().getResourceAsStream("ncjms.properties"));
            }
        }
        catch (Throwable e) {
            throw new PropertiesException(I18NCode.MSG_FAILED_TO_READ_PROPERTIES);
        }
    }

    public String getProperty(JMSProperty property) {
        String value = (String)this.m_props.get(property.getKey());
        return value;
    }

    public static JMSProperties getInstance() {
        return m_instance;
    }

    public static class JMSProperty {
        private String m_key;

        public JMSProperty(String key) {
            this.m_key = key;
        }

        public String getKey() {
            return this.m_key;
        }
    }
}

