/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.lock;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.lock.LockOwner;
import com.cognos.jsmcommon.lock.LockProperties;
import com.cognos.jsmcommon.lock.ResourceLock;
import com.cognos.jsmcommon.lock.ResourceLockException;
import com.cognos.jsmcommon.lock.ResourceLocker;
import com.cognos.jsmcommon.lock.jvm.JvmResourceLockFactory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.util.Date;

public class DistributedResourceLock
implements ResourceLock {
    private LockProperties lock;
    private LockOwner lockOwner;
    private String resource;
    private ResourceLock jvmLock;
    private boolean aquireJvmLock = true;
    private ResourceLocker resourceLocker;
    private Date timestamp;

    public DistributedResourceLock(boolean jvmLock, ResourceLocker resourceLocker, LockOwner lockOwner, String resource) {
        this(resourceLocker, lockOwner, resource);
        this.aquireJvmLock = jvmLock;
    }

    public DistributedResourceLock(ResourceLocker resourceLocker, LockOwner lockOwner, String resource) {
        this.lockOwner = lockOwner;
        this.resource = resource;
        this.resourceLocker = resourceLocker;
    }

    public boolean isAquireJvmLock() {
        return this.aquireJvmLock;
    }

    public void setAquireJvmLock(boolean aquireJvmLock) {
        this.aquireJvmLock = aquireJvmLock;
    }

    @Override
    public void lock() throws ResourceLockException {
        if (this.aquireJvmLock) {
            this.jvmLock = JvmResourceLockFactory.instance().getLock(this.resource);
            this.jvmLock.lock();
        }
        this.setTimeStamp(new Date());
        try {
            this.resourceLocker.lock(this);
        }
        catch (Throwable t) {
            if (this.jvmLock != null) {
                this.jvmLock.unlock();
            }
            throw new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_FAIL, new Object[]{this.resource, "null"});
        }
        if (this.lock == null) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("distributed lock properties were null?");
            if (this.jvmLock != null) {
                this.jvmLock.unlock();
            }
            throw new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_FAIL, new Object[]{this.resource, "null"});
        }
        if (this.lock.getError() != null) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("lock error: " + this.lock.getError().getLocalizedMessage());
            if (this.jvmLock != null) {
                this.jvmLock.unlock();
            }
            throw this.lock.getError();
        }
        this.setTimeStamp(new Date());
    }

    @Override
    public void unlock() throws ResourceLockException {
        if (this.lock == null) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("unlock called when not locked!");
            throw new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_FAIL, new Object[]{this.resource, "null"});
        }
        SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("DistributedResourceLock: unlock: resourceLocker unlocking...");
        this.resourceLocker.unlock(this);
        SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("DistributedResourceLock: unlock: resourceLocker unlocked");
        this.lock = null;
        if (this.jvmLock != null) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("DistributedResourceLock: unlock: jvmLock unlocking...");
            this.jvmLock.unlock();
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("DistributedResourceLock: unlock: jvmLock unlocked");
        }
    }

    @Override
    public void setLock(LockProperties lockProperties) {
        this.lock = lockProperties;
    }

    @Override
    public LockProperties getLock() {
        return this.lock;
    }

    @Override
    public boolean isLocked() {
        boolean isLocked = this.jvmLock == null || this.jvmLock.isLocked();
        isLocked = isLocked && this.lock != null;
        isLocked = isLocked && this.lock.getOwner() != null;
        isLocked = isLocked && this.lock.getOwner().equals(this.lockOwner.getName());
        return isLocked && this.getError() == null;
    }

    @Override
    public ResourceLockException getError() {
        return this.lock != null ? this.lock.getError() : null;
    }

    @Override
    public LockOwner getOwner() {
        return this.lockOwner;
    }

    @Override
    public String getResource() {
        return this.resource;
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimeStamp(Date start) {
        this.timestamp = start;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DistributedResourceLock other = (DistributedResourceLock)obj;
        if (this.lockOwner == null || other.lockOwner == null) {
            return false;
        }
        if (!this.lockOwner.getName().equals(other.lockOwner.getName())) {
            return false;
        }
        if (this.resource == null || other.resource == null) {
            return false;
        }
        return this.resource.equals(other.resource);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lockOwner == null ? 0 : this.lockOwner.getName().hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public String toString() {
        return "DistributedResourceLock [lockOwner=" + this.lockOwner.getName() + ", resource=" + this.resource + "]";
    }
}

