/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.lock;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.lock.LockAccess;
import com.cognos.jsmcommon.lock.LockOwner;
import com.cognos.jsmcommon.lock.LockProperties;
import com.cognos.jsmcommon.lock.ResourceLock;
import com.cognos.jsmcommon.lock.ResourceLockException;
import com.cognos.jsmcommon.lock.jvm.JvmResourceLockFactory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.util.HashList;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class ResourceLocker
implements Runnable {
    private static final String THREAD_NAME = "jsm-resource-locker-thread";
    private static final int defaultLockWaitTime = 2000;
    private static final int defaultMaxLockWaitTime = 600000;
    private static final boolean sysout = false;
    private static final String debugPrefix = ResourceLocker.class.getName() + ": ";
    boolean accessIsAvailable = true;
    private LockAccess lockAccess;
    private Thread dataSourceUnlockCheckThread;
    private HashList<String, ResourceLock> pendingLocks = new HashList();
    private HashSet<ResourceLock> lockedLocks = new HashSet();
    private HashSet<ResourceLock> failedUnLocks = new HashSet();
    private boolean running = false;
    private static Boolean verbose = null;

    public ResourceLocker(LockAccess lockAccess) {
        this.lockAccess = lockAccess;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(ResourceLock lock) throws ResourceLockException {
        if (!this.accessIsAvailable && !this.lockAccess.isAvailable() || !this.running) {
            this.debug("accessIsAvailable = " + this.accessIsAvailable);
            this.debug("lockAccess.isAvailable() = " + this.lockAccess.isAvailable());
            this.debug("running = " + this.running);
            throw new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_FAIL, new Object[]{lock.getResource(), lock.getOwner()});
        }
        Object object = this.pendingLocks;
        synchronized (object) {
            this.pendingLocks.put(lock.getResource(), lock);
            this.pendingLocks.notify();
            this.debug(" about to wait for lock " + lock);
        }
        object = lock;
        synchronized (object) {
            while (!lock.isLocked() && lock.getError() == null) {
                try {
                    lock.wait();
                }
                catch (InterruptedException e) {
                    this.debug("ERROR - interrupted in wait for " + lock);
                }
            }
        }
        if (lock.getError() != null) {
            throw lock.getError();
        }
        if (!lock.isLocked()) {
            this.debug("ERROR - fallen out of the lock wait");
            throw new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_FAIL, new Object[]{lock.getResource(), lock.getOwner()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void park() {
        if (!this.accessIsAvailable) {
            this.checkLockAccess();
        }
        HashList<String, ResourceLock> hashList = this.pendingLocks;
        synchronized (hashList) {
            try {
                if (this.pendingLocks.size() > 0) {
                    this.pendingLocks.wait(ResourceLocker.getWait());
                } else if (this.lockedLocks.size() > 0) {
                    this.pendingLocks.wait(ResourceLocker.getMaxWait());
                } else {
                    this.pendingLocks.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLockAccess() {
        this.accessIsAvailable = this.lockAccess.isAvailable();
        if (!this.accessIsAvailable) {
            HashList<String, ResourceLock> hashList = this.pendingLocks;
            synchronized (hashList) {
                try {
                    Collection<ResourceLock> allLocks = this.pendingLocks.values();
                    allLocks.addAll(this.lockedLocks);
                    for (ResourceLock resourceLock : allLocks) {
                        LockProperties lock = new LockProperties();
                        lock.setError(new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_FAIL, new Object[]{lock.getResource(), lock.getOwner()}));
                        this.setLocked(resourceLock, lock);
                    }
                    this.pendingLocks.wait(ResourceLocker.getMaxWait());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private String makeLockString(Collection<ResourceLock> locks) {
        String debug = "";
        for (ResourceLock lock : locks) {
            if (lock == null) continue;
            debug = debug + lock.getResource() + ": " + lock.getOwner().getName() + ", ";
        }
        return debug;
    }

    private String makeLockPropertiesString(Collection<LockProperties> lockProperties) {
        String debug = "";
        for (LockProperties lockProperties2 : lockProperties) {
            if (lockProperties2 == null) continue;
            debug = debug + lockProperties2.getResource() + ": " + lockProperties2.getOwner() + ", ";
        }
        return debug;
    }

    private void checkStaleLocks() {
        if (!this.lockAccess.isAvailable()) {
            return;
        }
        ArrayList<ResourceLock> unlocked = new ArrayList<ResourceLock>();
        for (ResourceLock waitingForUnlock : this.failedUnLocks) {
            try {
                waitingForUnlock.unlock();
                unlocked.add(waitingForUnlock);
            }
            catch (ResourceLockException e) {
                this.debug("unlock retry ", e);
            }
        }
        this.failedUnLocks.removeAll(unlocked);
        for (ResourceLock waitingForUnlock : this.lockedLocks) {
            this.lockCleanup(waitingForUnlock, ResourceLocker.getMaxWait());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLocks() {
        List<ResourceLock> lockList = null;
        HashList<String, ResourceLock> hashList = this.pendingLocks;
        synchronized (hashList) {
            if (this.pendingLocks.isEmpty()) {
                this.checkStaleLocks();
                return;
            }
            lockList = this.pendingLocks.getFirstValues();
        }
        List<LockProperties> lockPropertiesList = null;
        try {
            this.verboseDebugLocks("requesting locks for ", lockList);
            lockPropertiesList = this.lockAccess.lockResources(lockList);
            this.accessIsAvailable = true;
            this.verboseDebugLockProperties("got locks for ", lockPropertiesList);
        }
        catch (ResourceLockException e) {
            this.debug("ERROR - lock access error ", e);
            this.accessIsAvailable = false;
            return;
        }
        HashList<String, ResourceLock> hashList2 = this.pendingLocks;
        synchronized (hashList2) {
            for (ResourceLock lock : lockList) {
                LockProperties lockProperties = this.findLockPropertiesFromList(lockPropertiesList, lock);
                if (lockProperties != null && lock != null) {
                    this.processOneLock(lock, lockProperties);
                    continue;
                }
                if (lock != null && lock.getTimestamp() != null) {
                    this.processMaxWait(lock);
                    continue;
                }
                this.debug("ERROR - in ResourceLock locker thread lock resources - unmatched lockProperties");
            }
        }
    }

    private LockProperties findLockPropertiesFromList(List<LockProperties> locksPropertiesList, ResourceLock resourceLock) {
        for (LockProperties properties : locksPropertiesList) {
            if (properties == null || !resourceLock.getResource().equals(properties.getResource()) || !resourceLock.getOwner().getName().equals(properties.getOwner())) continue;
            return properties;
        }
        return null;
    }

    private void processOneLock(ResourceLock lock, LockProperties lockProperties) {
        if (lock == null || lockProperties == null) {
            this.debug("ERROR - null lock in ResourceLocker probably due to lock access contention");
            return;
        }
        if (lockProperties.getOwner().equals(lock.getOwner().getName())) {
            this.setLocked(lock, lockProperties);
        } else {
            this.debug("ERROR - lock has wrong owner " + lockProperties.getOwner() + ":" + lock.getOwner().getName() + " process max wait");
            this.processMaxWait(lock);
        }
    }

    private void processMaxWait(ResourceLock lock) {
        Date now = new Date();
        long wait = now.getTime() - lock.getTimestamp().getTime();
        if (wait < ResourceLocker.getMaxWait()) {
            return;
        }
        if (ResourceLocker.getVerbose()) {
            try {
                List<LockProperties> existingLocks = this.lockAccess.listLocks();
                this.verboseDebugLockProperties("existing locks ", existingLocks);
            }
            catch (ResourceLockException e) {
                this.debug("error listing locks ", e);
            }
        }
        this.debug("processing max wait .. " + lock);
        LockProperties lockProperties = null;
        try {
            lockProperties = this.lockAccess.getLock(lock.getResource());
        }
        catch (ResourceLockException e) {
            lockProperties = new LockProperties();
        }
        lockProperties.setError(new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_WAIT_TIMEOUT, new Object[]{lock.getResource(), wait}));
        this.setLocked(lock, lockProperties);
        this.lockCleanup(lock, ResourceLocker.getMaxWait());
    }

    private void lockCleanup(ResourceLock resource, long max_wait) {
        Date now = new Date();
        long wait = now.getTime() - resource.getTimestamp().getTime();
        if (wait < max_wait) {
            return;
        }
        try {
            LockProperties deadLock = this.lockAccess.getLock(resource.getResource());
            if (deadLock == null) {
                return;
            }
            LockOwner otherOwner = resource.getOwner().makeOwner(deadLock.getOwner());
            if (otherOwner != null && !otherOwner.isOwnerValid()) {
                this.debug("processing lock cleanup for deadOwner " + otherOwner.getName());
                int count = this.lockAccess.breakLocksForOwner(otherOwner.getName());
                JvmResourceLockFactory.instance().breakLocksForOwner(otherOwner);
                this.debug("cleaned " + count + " locks for deadOwner " + otherOwner.getName());
            }
        }
        catch (Throwable e) {
            this.debug("ERROR - attempting cleanup for dead owner " + resource.getOwner().getName(), e);
            this.accessIsAvailable = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(ResourceLock lock) throws ResourceLockException {
        try {
            Object object = lock;
            synchronized (object) {
                this.lockAccess.unlockResource(lock);
            }
            object = this.pendingLocks;
            synchronized (object) {
                if (!this.lockedLocks.remove(lock)) {
                    this.debug("ERROR - " + lock + " lock not found in map");
                } else {
                    this.debug("unlocked " + lock);
                }
                this.pendingLocks.notify();
            }
        }
        catch (ResourceLockException e) {
            this.debug("ERROR - unlocking " + lock, e);
            this.failedUnLocks.add(lock);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLocked(ResourceLock lock, LockProperties lockProperties) {
        ResourceLock resourceLock = lock;
        synchronized (resourceLock) {
            try {
                lock.setLock(lockProperties);
                HashList<String, ResourceLock> hashList = this.pendingLocks;
                synchronized (hashList) {
                    this.pendingLocks.remove(lock.getResource(), lock);
                    if (lockProperties.getError() == null) {
                        this.lockedLocks.add(lock);
                        this.debug("locked resource " + lock);
                    } else {
                        this.debug("error locking resource " + lock, lockProperties.getError());
                    }
                }
            }
            finally {
                lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getState() {
        HashList<String, ResourceLock> hashList = this.pendingLocks;
        synchronized (hashList) {
            return " pending locks(" + this.makeLockString(this.pendingLocks.values()) + ") held locks(" + this.makeLockString(this.lockedLocks);
        }
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.dataSourceUnlockCheckThread = new Thread(this);
        this.dataSourceUnlockCheckThread.setName(THREAD_NAME);
        this.dataSourceUnlockCheckThread.setDaemon(true);
        this.dataSourceUnlockCheckThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        if (this.dataSourceUnlockCheckThread != null) {
            this.dataSourceUnlockCheckThread.interrupt();
            this.dataSourceUnlockCheckThread = null;
        }
        HashList<String, ResourceLock> hashList = this.pendingLocks;
        synchronized (hashList) {
            for (ResourceLock lock : this.pendingLocks.values()) {
                LockProperties lockProperties = new LockProperties();
                lockProperties.setError(new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_FAIL, new Object[]{lock.getResource(), ""}));
                this.setLocked(lock, lockProperties);
            }
        }
    }

    private void verboseDebugLocks(String message, Collection<ResourceLock> locks) {
        if (ResourceLocker.getVerbose()) {
            this.debug(message + this.makeLockString(locks) + this.getState());
        }
    }

    private void verboseDebugLockProperties(String message, Collection<LockProperties> lockProperties) {
        if (ResourceLocker.getVerbose()) {
            this.debug(message + this.makeLockPropertiesString(lockProperties) + this.getState());
        }
    }

    private void debug(String message, Throwable t) {
        this.debug(message);
        SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(t);
    }

    private void debug(String message) {
        message = debugPrefix + message;
        SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(message);
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                this.park();
                this.processLocks();
            }
            catch (Throwable t) {
                this.debug("error in ResourceLock unlocker thread", t);
                this.accessIsAvailable = false;
            }
        }
        this.debug("jsm-resource-locker-thread finished run");
    }

    private static boolean getVerbose() {
        if (verbose == null) {
            try {
                verbose = Boolean.valueOf(CRNProperties.getInstance().getProperty("com.cognos.jsmcommon.lock.verbose"));
            }
            catch (Throwable t) {
                return false;
            }
        }
        return verbose;
    }

    public static long getWait() {
        return CRNProperties.getInstance().getIntProperty("com.cognos.jsmcommon.lock.wait.interval", 2000);
    }

    public static long getMaxWait() {
        return CRNProperties.getInstance().getIntProperty("com.cognos.jsmcommon.lock.wait.timeout", 600000);
    }
}

