/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.lock;

import com.cognos.jsmcommon.lock.LockOwner;
import com.cognos.jsmcommon.lock.ResourceLockException;
import com.cognos.jsmcommon.objectid.GuidIdGenerator;
import com.cognos.jsmcommon.serverinst.SDSInstanceManager;

public class SdsInstanceLockOwner
implements LockOwner {
    private static String mySdsInstance = SDSInstanceManager.getInstance().getThisInstance().getGuid();
    private String sdsInstance;

    public SdsInstanceLockOwner() {
        this.sdsInstance = mySdsInstance;
    }

    public SdsInstanceLockOwner(String instance) {
        this.sdsInstance = instance;
    }

    @Override
    public String getName() {
        return this.sdsInstance;
    }

    @Override
    public boolean isOwnerValid() throws ResourceLockException {
        boolean valid = this.sdsInstance.equals(SDSInstanceManager.getInstance().getThisInstance().getGuid());
        if (!valid) {
            valid = GuidIdGenerator.validOidString(this.sdsInstance);
            valid = valid && SDSInstanceManager.getInstance().getSDSInstance(this.sdsInstance) != null;
        }
        return valid;
    }

    @Override
    public LockOwner makeOwner(String owner) {
        return new SdsInstanceLockOwner(owner);
    }
}

