/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.lock.database;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.lock.LockAccess;
import com.cognos.jsmcommon.lock.LockProperties;
import com.cognos.jsmcommon.lock.ResourceLock;
import com.cognos.jsmcommon.lock.ResourceLockException;
import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.sql.util.SQLExecuteHandler;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class NCDBLockAccess
implements LockAccess {
    private static final String SELECT_ALL = "SELECT LOCK_RESOURCE, OWNER, TIMESTAMP FROM NC_RESOURCE_LOCK";
    private static final String DELETE_WHERE_OWNER = "DELETE FROM NC_RESOURCE_LOCK WHERE OWNER = ?";
    private static final String SELECT_WHERE_RESOURCE = "SELECT LOCK_RESOURCE, OWNER, TIMESTAMP FROM NC_RESOURCE_LOCK WHERE LOCK_RESOURCE = ?";
    private static final String DELETE_WHERE_RESOURCE_AND_OWNER = "DELETE FROM NC_RESOURCE_LOCK WHERE LOCK_RESOURCE = ? AND OWNER = ?";
    private static final String INSERT_INTO = "INSERT INTO NC_RESOURCE_LOCK (LOCK_RESOURCE, OWNER, TIMESTAMP) VALUES (?, ?, ?) ";
    public static final int TEXT_COL_LENGTH = 50;

    @Override
    public LockProperties getLock(String resource) throws ResourceLockException {
        final String trimResource = this.trimCheck(resource);
        SQLExecute<LockProperties> sqlExecute = new SQLExecute<LockProperties>(){

            @Override
            public LockProperties execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                LockProperties properties = null;
                try {
                    ps = TaskPersistLayer.prepareStatement(NCDBLockAccess.SELECT_WHERE_RESOURCE);
                    ps.setString(1, trimResource);
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        String resource = rs.getString(1).trim();
                        String owner = rs.getString(2).trim();
                        long date = rs.getLong(3);
                        properties = new LockProperties(resource, owner, new Date(date));
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return properties;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCDBLockAccess.getLock");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            LockProperties lockProperties = handler.execute(sqlExecute);
            return lockProperties;
        }
        catch (TaskPersistLayerException tple) {
            throw new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_FAIL, new Object[]{resource, "null"}, tple);
        }
        finally {
            zipiTimer.stop();
        }
    }

    @Override
    public boolean isAvailable() {
        boolean accessOk = false;
        try {
            this.getLock("dummy");
            accessOk = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return accessOk;
    }

    @Override
    public int breakLocksForOwner(String owner) throws ResourceLockException {
        final String trimOwner = this.trimCheck(owner);
        SQLExecute<Integer> sqlExecute = new SQLExecute<Integer>(){

            @Override
            public Integer execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                int result = -1;
                try {
                    ps = TaskPersistLayer.prepareStatement(NCDBLockAccess.DELETE_WHERE_OWNER);
                    ps.setString(1, trimOwner);
                    result = ps.executeUpdate();
                }
                catch (SQLException e) {
                    throw new TaskPersistLayerException(e);
                }
                finally {
                    TaskPersistLayer.closeStatement(ps, null);
                }
                return result;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCDBLockAccess.breakLocksForOwner");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            int n = handler.execute(sqlExecute);
            return n;
        }
        catch (TaskPersistLayerException tple) {
            throw new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_FAIL, new Object[]{null, owner}, tple);
        }
        finally {
            zipiTimer.stop();
        }
    }

    private String trimCheck(String value) throws ResourceLockException {
        if (value == null) {
            throw new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_FAIL, new Object[]{null, "null"});
        }
        if (value.length() > 50) {
            throw new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_FAIL, new Object[]{value, "null"});
        }
        return value.trim();
    }

    private LockProperties lockResource(ResourceLock resource) throws ResourceLockException {
        PreparedStatement ps = null;
        int result = 0;
        LockProperties lockProperties = null;
        if (resource == null || resource.getOwner() == null) {
            throw new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_FAIL, new Object[]{null, "null"});
        }
        String resourceKey = this.trimCheck(resource.getResource());
        String owner = this.trimCheck(resource.getOwner().getName());
        try {
            ps = TaskPersistLayer.prepareStatement(INSERT_INTO);
            Date timestamp = new Date();
            lockProperties = new LockProperties(resourceKey, owner, timestamp);
            ps.setString(1, this.trimCheck(resourceKey));
            ps.setString(2, this.trimCheck(owner));
            ps.setLong(3, timestamp.getTime());
            result = ps.executeUpdate();
        }
        catch (SQLException e) {
            if (result != 0) {
                throw new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_FAIL, new Object[]{null, "null"});
            }
        }
        catch (TaskPersistLayerException tple) {
            throw new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_FAIL, new Object[]{null, "null"}, tple);
        }
        finally {
            TaskPersistLayer.closeStatement(ps, null);
        }
        return result > 0 ? lockProperties : null;
    }

    @Override
    public List<LockProperties> lockResources(List<ResourceLock> resources) throws ResourceLockException {
        ArrayList<LockProperties> returnedLockProperties = new ArrayList<LockProperties>();
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCDBLockAccess.lockResources");
        try {
            TaskPersistLayer.checkCreateConnection(false, 2);
            for (ResourceLock resourceLock : resources) {
                returnedLockProperties.add(this.lockResource(resourceLock));
            }
        }
        catch (TaskPersistLayerException tple) {
            StringBuilder exLog = new StringBuilder();
            for (ResourceLock lock : resources) {
                exLog.append(lock.getResource()).append(",");
            }
            throw new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_FAIL, new Object[]{exLog, "null"}, tple);
        }
        finally {
            TaskPersistLayer.checkCloseConnection();
            zipiTimer.stop();
        }
        return returnedLockProperties;
    }

    @Override
    public void unlockResource(ResourceLock resource) throws ResourceLockException {
        final String trimResource = this.trimCheck(resource.getResource());
        final String trimOwner = this.trimCheck(resource.getOwner().getName());
        SQLExecute<Integer> sqlExecute = new SQLExecute<Integer>(){

            @Override
            public Integer execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                int result = -1;
                try {
                    ps = TaskPersistLayer.prepareStatement(NCDBLockAccess.DELETE_WHERE_RESOURCE_AND_OWNER);
                    ps.setString(1, trimResource);
                    ps.setString(2, trimOwner);
                    result = ps.executeUpdate();
                }
                catch (SQLException e) {
                    throw new TaskPersistLayerException(e);
                }
                finally {
                    TaskPersistLayer.closeStatement(ps, null);
                }
                return result;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCDBLockAccess.unlockResource");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            int result = handler.execute(sqlExecute);
            if (result != 1) {
                throw new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_FAIL, new Object[]{resource, "null"});
            }
        }
        catch (TaskPersistLayerException tple) {
            throw new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_FAIL, new Object[]{resource, "null"}, tple);
        }
        finally {
            zipiTimer.stop();
        }
    }

    @Override
    public List<LockProperties> listLocks() throws ResourceLockException {
        SQLExecute<List<LockProperties>> sqlExecute = new SQLExecute<List<LockProperties>>(){

            @Override
            public List<LockProperties> execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                ArrayList<LockProperties> properties = new ArrayList<LockProperties>();
                try {
                    ps = TaskPersistLayer.prepareStatement(NCDBLockAccess.SELECT_ALL);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        String resource = rs.getString(1).trim();
                        String owner = rs.getString(2).trim();
                        long date = rs.getLong(3);
                        properties.add(new LockProperties(resource, owner, new Date(date)));
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new TaskPersistLayerException(e);
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                }
                TaskPersistLayer.closeStatement(ps, rs);
                return properties;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer("NCTSEStateMapTableInDatabase.insertRecords");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
            List<LockProperties> list = handler.execute(sqlExecute);
            return list;
        }
        catch (TaskPersistLayerException tple) {
            throw new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_FAIL, new Object[]{null, "null"}, tple);
        }
        finally {
            zipiTimer.stop();
        }
    }
}

