/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.lock.database;

import com.cognos.jsmcommon.lock.DistributedResourceLock;
import com.cognos.jsmcommon.lock.LockAccess;
import com.cognos.jsmcommon.lock.LockOwner;
import com.cognos.jsmcommon.lock.LockProperties;
import com.cognos.jsmcommon.lock.ResourceLock;
import com.cognos.jsmcommon.lock.ResourceLockException;
import com.cognos.jsmcommon.lock.ResourceLockFactory;
import com.cognos.jsmcommon.lock.ResourceLocker;
import com.cognos.jsmcommon.lock.SdsInstanceLockOwner;
import com.cognos.jsmcommon.lock.SdsInstanceLockOwnerListener;
import com.cognos.jsmcommon.lock.database.NCDBLockAccess;
import com.cognos.jsmcommon.lock.jvm.JvmResourceLockFactory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.serverinst.SDSInstanceManager;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.util.HashSet;
import java.util.List;

public final class NCDBResourceLockFactory
implements ResourceLockFactory {
    private LockOwner sdsInstanceLockOwner;
    private LockAccess lockAccess = new NCDBLockAccess();
    private ResourceLocker resourceLocker;
    private boolean jvmLock;
    private SdsInstanceLockOwnerListener failListener;

    public NCDBResourceLockFactory(boolean jvmLock, SDSInstanceManager manager) {
        this.sdsInstanceLockOwner = new SdsInstanceLockOwner(manager.getThisInstance().getGuid());
        this.resourceLocker = new ResourceLocker(this.lockAccess);
        this.jvmLock = jvmLock;
        this.failListener = new SdsInstanceLockOwnerListener(this.lockAccess);
        SDSInstanceManager.getInstance().addInstanceListener(this.failListener);
    }

    public NCDBResourceLockFactory(boolean jvmLock) {
        this.sdsInstanceLockOwner = new SdsInstanceLockOwner();
        this.resourceLocker = new ResourceLocker(this.lockAccess);
        this.jvmLock = jvmLock;
        this.failListener = new SdsInstanceLockOwnerListener(this.lockAccess);
        SDSInstanceManager.getInstance().addInstanceListener(this.failListener);
    }

    private void doStaleInstanceChecks() {
        try {
            List<LockProperties> lockProperties = this.lockAccess.listLocks();
            String previousId = SDSInstanceManager.getInstance().getRecoveredFromCrash();
            HashSet<String> checkedOwners = new HashSet<String>();
            for (LockProperties lostProperty : lockProperties) {
                if (checkedOwners.contains(lostProperty.getOwner())) continue;
                LockOwner owner = this.sdsInstanceLockOwner.makeOwner(lostProperty.getOwner());
                if (!owner.isOwnerValid() || owner.getName().equals(previousId)) {
                    this.lockAccess.breakLocksForOwner(owner.getName());
                }
                checkedOwners.add(lostProperty.getOwner());
            }
        }
        catch (ResourceLockException e) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("resource lock instance failed error");
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(e);
        }
    }

    @Override
    public ResourceLock getLock(String resource, LockOwner owner) {
        return new DistributedResourceLock(this.jvmLock, this.resourceLocker, owner, resource);
    }

    @Override
    public ResourceLock getLock(String resource) {
        return new DistributedResourceLock(this.jvmLock, this.resourceLocker, this.sdsInstanceLockOwner, resource);
    }

    @Override
    public void close() {
        this.resourceLocker.stop();
        SDSInstanceManager.getInstance().removeInstanceListener(this.failListener);
    }

    @Override
    public void stop() {
        this.resourceLocker.stop();
        JvmResourceLockFactory.instance().stop();
        try {
            this.lockAccess.breakLocksForOwner(this.sdsInstanceLockOwner.getName());
        }
        catch (ResourceLockException e) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("resource lock instance stop error");
        }
    }

    @Override
    public void start() {
        SDSInstanceManager.getInstance().removeInstanceListener(this.failListener);
        this.doStaleInstanceChecks();
        this.resourceLocker.start();
        SDSInstanceManager.getInstance().addInstanceListener(this.failListener);
    }
}

