/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.lock.database;

import com.cognos.jsmcommon.lock.ResourceLockException;
import com.cognos.jsmcommon.lock.ResourceLockFactory;
import com.cognos.jsmcommon.lock.ResourceLockManager;
import com.cognos.jsmcommon.lock.database.NCDBResourceLockFactory;
import com.cognos.jsmcommon.lock.jvm.JvmResourceLockFactory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.serverinst.InstanceFailedEvent;
import com.cognos.jsmcommon.serverinst.SDSInstance;
import com.cognos.jsmcommon.serverinst.SDSInstanceListener;
import com.cognos.jsmcommon.serverinst.SDSInstanceManager;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.util.List;

public class SdsInstanceAwareResourceLockManager
extends ResourceLockManager {
    private SDSInstanceListener sdsInstanceListener;
    private ResourceLockFactory originalResourceLockfactory = this.getResourceLockfactory();
    private static SdsInstanceAwareResourceLockManager instance;

    public SdsInstanceAwareResourceLockManager() throws ResourceLockException {
        this(new NCDBResourceLockFactory(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SdsInstanceAwareResourceLockManager instance() throws ResourceLockException {
        if (instance != null) return instance;
        Class<SdsInstanceAwareResourceLockManager> clazz = SdsInstanceAwareResourceLockManager.class;
        synchronized (SdsInstanceAwareResourceLockManager.class) {
            if (instance != null) return instance;
            instance = new SdsInstanceAwareResourceLockManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static synchronized void clearInstance() {
        if (instance != null) {
            instance.stop();
            instance = null;
        }
    }

    public SdsInstanceAwareResourceLockManager(NCDBResourceLockFactory factory) throws ResourceLockException {
        super(factory);
        this.sdsInstanceListener = new SDSInstanceListener(){

            @Override
            public void instanceFailed(InstanceFailedEvent event) {
            }

            @Override
            public void otherInstanceCountChanged(List<SDSInstance> otherInstances) {
                try {
                    if (otherInstances != null && otherInstances.size() == 0) {
                        SdsInstanceAwareResourceLockManager.this.switchFactory(JvmResourceLockFactory.instance());
                    } else {
                        SdsInstanceAwareResourceLockManager.this.switchFactory(null);
                    }
                }
                catch (ResourceLockException e) {
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("failed to start resourceLockFactory");
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(e);
                }
            }
        };
        SDSInstanceManager.getInstance().addInstanceListener(this.sdsInstanceListener);
        SDSInstanceManager.getInstance().doStaleInstanceChecks();
        SDSInstanceManager.getInstance().notifyInstancesChanged();
        this.start();
    }

    private void switchFactory(ResourceLockFactory factory) throws ResourceLockException {
        ResourceLockFactory newFactory = factory == null ? this.originalResourceLockfactory : factory;
        SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("Setting resource lock factory to " + newFactory.getClass().getName());
        this.setResourceLockFactory(newFactory);
    }

    @Override
    public void close() {
        super.close();
        SDSInstanceManager.getInstance().removeInstanceListener(this.sdsInstanceListener);
    }

    public SDSInstanceListener getSdsInstanceListener() {
        return this.sdsInstanceListener;
    }

    public void setSdsInstanceListener(SDSInstanceListener sdsInstanceListener) {
        this.sdsInstanceListener = sdsInstanceListener;
    }
}

