/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.lock.filesystem;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.lock.LockAccess;
import com.cognos.jsmcommon.lock.LockOwner;
import com.cognos.jsmcommon.lock.LockProperties;
import com.cognos.jsmcommon.lock.ResourceLock;
import com.cognos.jsmcommon.lock.ResourceLockException;
import com.cognos.jsmcommon.lock.filesystem.FileLockOwner;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileLockAccess
implements LockAccess {
    private static String lockDir = "locks";
    private File lockDirectory;
    private Map<String, FileOutputStream> locks = Collections.synchronizedMap(new HashMap());

    public FileLockAccess(File lockDirectory) {
        this.lockDirectory = new File(lockDirectory, lockDir);
        this.lockDirectory.mkdirs();
    }

    @Override
    public synchronized List<LockProperties> lockResources(List<ResourceLock> resources) throws ResourceLockException {
        ArrayList<LockProperties> lockProperties = new ArrayList<LockProperties>();
        for (ResourceLock resourceLock : resources) {
            LockProperties madeLockProperties = this.lockResource(resourceLock.getResource(), resourceLock.getOwner());
            if (madeLockProperties == null) continue;
            lockProperties.add(madeLockProperties);
        }
        return lockProperties;
    }

    public synchronized LockProperties lockResource(String resource, LockOwner newOwner) throws ResourceLockException {
        File lockRowFile = new File(this.lockDirectory, resource);
        LockProperties lockProperties = this.getLock(lockRowFile);
        if (lockProperties != null) {
            LockOwner otherOwner = newOwner.makeOwner(lockProperties.getOwner());
            if (!otherOwner.isOwnerValid()) {
                lockProperties = this.writeLockFile(resource, lockRowFile, newOwner);
            } else if (otherOwner.getName().equals(newOwner.getName())) {
                lockProperties = lockProperties.clone();
                lockProperties.setError(new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_ALREADY_LOCKED, new Object[]{lockProperties.getOwner(), lockProperties.getResource()}));
            }
        } else {
            lockProperties = this.writeLockFile(resource, lockRowFile, newOwner);
        }
        return lockProperties;
    }

    @Override
    public synchronized boolean isAvailable() {
        try {
            File temp = File.createTempFile("fileLockCheck", "test", this.lockDirectory);
            return temp.delete();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public synchronized LockProperties getLock(String resource) throws ResourceLockException {
        File lockRowFile = new File(this.lockDirectory, resource);
        if (lockRowFile.exists()) {
            return this.readLockFile(lockRowFile);
        }
        return null;
    }

    private LockProperties getLock(File lockRowFile) throws ResourceLockException {
        if (lockRowFile.exists()) {
            return this.readLockFile(lockRowFile);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockProperties readLockFile(File lockRowFile) {
        LockProperties properties = null;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(lockRowFile);
            ois = new ObjectInputStream(fis);
            properties = (LockProperties)ois.readObject();
        }
        catch (Exception e) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("error in Filelock access " + e.getMessage());
        }
        finally {
            try {
                ois.close();
                fis.close();
            }
            catch (Throwable throwable) {}
        }
        return properties;
    }

    private void saveLock(String resource, File lockRowFile, LockOwner owner) throws IOException {
        FileOutputStream lockStream = new FileOutputStream(lockRowFile.getAbsolutePath() + ".lock");
        lockStream.write(1);
        lockStream.flush();
        this.locks.put(resource + owner.getName(), lockStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockProperties writeLockFile(String resource, File lockRowFile, LockOwner owner) {
        LockProperties lockProperties = new LockProperties(resource, owner.getName(), new Date());
        OutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            this.saveLock(resource, lockRowFile, owner);
            fos = new FileOutputStream(lockRowFile, false);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(lockProperties);
        }
        catch (Throwable e) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("error in Filelock access " + e.getMessage());
            lockProperties = null;
        }
        finally {
            try {
                oos.flush();
                oos.close();
                fos.flush();
                ((FileOutputStream)fos).close();
            }
            catch (IOException iOException) {}
        }
        return lockProperties;
    }

    @Override
    public synchronized int breakLocksForOwner(String owner) throws ResourceLockException {
        int count = 0;
        try {
            FileLockOwner lockOwner = new FileLockOwner(owner, this.lockDirectory.getParentFile());
            if (!lockOwner.deleteOwner()) {
                throw new Exception();
            }
            List<LockProperties> lockPropertiesList = this.listLocks();
            for (LockProperties lockProperties : lockPropertiesList) {
                if (!lockProperties.getOwner().equals(owner) || this.unlockResource(lockProperties.getResource()) == null) continue;
                ++count;
            }
        }
        catch (Exception e) {
            throw new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_FAIL, new Object[]{owner, "null"});
        }
        return count;
    }

    public synchronized LockProperties unlockResource(String resource) throws ResourceLockException {
        File lockRowFile = new File(this.lockDirectory, resource);
        LockProperties lockProperties = this.readLockFile(lockRowFile);
        if (!lockRowFile.delete()) {
            throw new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_FAIL, new Object[]{"null", "null"});
        }
        return lockProperties;
    }

    @Override
    public synchronized void unlockResource(ResourceLock resource) throws ResourceLockException {
        try {
            this.locks.get(resource.getResource() + resource.getOwner().getName()).close();
        }
        catch (Throwable e) {
            throw new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_FAIL, new Object[]{resource.getResource(), resource.getOwner()});
        }
        File lockRowFile = new File(this.lockDirectory, resource.getResource());
        for (int i = 0; i < 5 && lockRowFile.exists() && !lockRowFile.delete(); ++i) {
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (lockRowFile.exists()) {
            throw new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_FAIL, new Object[]{"null", "null"});
        }
    }

    @Override
    public List<LockProperties> listLocks() throws ResourceLockException {
        File[] files = this.lockDirectory.listFiles();
        ArrayList<LockProperties> lockPropertiesList = new ArrayList<LockProperties>();
        for (File file : files) {
            lockPropertiesList.add(this.readLockFile(file));
        }
        return lockPropertiesList;
    }
}

