/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.lock.filesystem;

import com.cognos.jsmcommon.lock.LockOwner;
import com.cognos.jsmcommon.lock.ResourceLockException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;

public class FileLockOwner
implements LockOwner {
    private String name;
    private File tempDirectory;
    private FileOutputStream lockStream;
    private File lockFile;
    private static final String ownerDir = "owners";

    public static FileLockOwner makeUniquefileLockOwner(File tempDirectory) throws Exception {
        return new FileLockOwner(UUID.randomUUID().toString(), tempDirectory);
    }

    public FileLockOwner(String name, File tempDirectory) throws Exception {
        this.name = name;
        this.tempDirectory = new File(tempDirectory, ownerDir);
        this.tempDirectory.mkdirs();
        this.lockFile = new File(this.tempDirectory, name);
    }

    public boolean isCreated() throws Exception {
        return this.lockFile != null && this.lockStream != null;
    }

    public void create() throws Exception {
        boolean deleted;
        if (this.lockFile.exists() && !(deleted = this.lockFile.delete())) {
            throw new Exception();
        }
        this.lockStream = new FileOutputStream(this.lockFile);
    }

    public boolean deleteOwner() {
        if (!this.lockFile.exists()) {
            return true;
        }
        try {
            if (this.lockStream != null) {
                this.lockStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean deleted = false;
        while (!deleted) {
            deleted = this.lockFile.delete();
            if (!this.lockFile.exists()) {
                deleted = true;
                break;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return deleted;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isOwnerValid() throws ResourceLockException {
        boolean alive = this.lockFile.exists();
        try {
            alive = alive && !this.lockFile.delete();
        }
        catch (Throwable t) {
            alive = true;
        }
        return alive;
    }

    @Override
    public LockOwner makeOwner(String owner) {
        try {
            return new FileLockOwner(owner, this.tempDirectory.getParentFile());
        }
        catch (Exception e) {
            return null;
        }
    }
}

