/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.lock.filesystem;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.lock.DistributedResourceLock;
import com.cognos.jsmcommon.lock.LockAccess;
import com.cognos.jsmcommon.lock.LockOwner;
import com.cognos.jsmcommon.lock.ResourceLock;
import com.cognos.jsmcommon.lock.ResourceLockException;
import com.cognos.jsmcommon.lock.ResourceLockFactory;
import com.cognos.jsmcommon.lock.ResourceLocker;
import com.cognos.jsmcommon.lock.filesystem.FileLockAccess;
import com.cognos.jsmcommon.lock.filesystem.FileLockOwner;
import java.io.File;

public class FileResourceLockFactory
implements ResourceLockFactory {
    private FileLockOwner fileLockOwner;
    private LockAccess fileLockAccess;
    private ResourceLocker locker;
    private boolean aquireJvmLock = true;

    public FileResourceLockFactory(File tempDirectory, boolean aquireJvmLock) throws Exception {
        this(tempDirectory, aquireJvmLock, FileResourceLockFactory.createDefaultFileLockOwner(tempDirectory));
    }

    private static FileLockOwner createDefaultFileLockOwner(File tempDirectory) throws Exception {
        FileLockOwner defaultLockOwner = FileLockOwner.makeUniquefileLockOwner(tempDirectory);
        defaultLockOwner.create();
        return defaultLockOwner;
    }

    public FileResourceLockFactory(File tempDirectory, boolean aquireJvmLock, FileLockOwner defaultOwner) throws Exception {
        this.fileLockOwner = defaultOwner;
        this.fileLockAccess = new FileLockAccess(tempDirectory);
        this.locker = new ResourceLocker(this.fileLockAccess);
        this.aquireJvmLock = aquireJvmLock;
    }

    @Override
    public ResourceLock getLock(String resource) {
        DistributedResourceLock drl = new DistributedResourceLock(this.aquireJvmLock, this.locker, this.fileLockOwner, resource);
        drl.setAquireJvmLock(this.aquireJvmLock);
        return drl;
    }

    @Override
    public ResourceLock getLock(String resource, LockOwner owner) {
        DistributedResourceLock drl = new DistributedResourceLock(this.aquireJvmLock, this.locker, owner, resource);
        drl.setAquireJvmLock(this.aquireJvmLock);
        return drl;
    }

    @Override
    public void close() {
        this.stop();
    }

    @Override
    public void stop() {
        this.locker.stop();
        if (this.fileLockOwner != null) {
            this.fileLockOwner.deleteOwner();
        }
    }

    @Override
    public void start() throws ResourceLockException {
        this.locker.start();
        try {
            if (!this.fileLockOwner.isCreated()) {
                this.fileLockOwner.create();
            }
        }
        catch (Exception e) {
            throw new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_FAIL, new Object[0]);
        }
    }
}

