/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.lock.jvm;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.lock.LockOwner;
import com.cognos.jsmcommon.lock.LockProperties;
import com.cognos.jsmcommon.lock.ResourceLock;
import com.cognos.jsmcommon.lock.ResourceLockException;
import com.cognos.jsmcommon.lock.ThreadLockOwner;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.util.Date;

class JvmResourceLock
implements ResourceLock {
    private boolean m_lock = false;
    private String resource;
    private ThreadLockOwner owner;
    private Date lockDate;
    private ResourceLockException error;

    JvmResourceLock(String resource) {
        this.resource = resource;
    }

    @Override
    public synchronized boolean isLocked() {
        if (this.owner == null || !this.owner.isOwnerValid()) {
            try {
                this.unlock();
            }
            catch (ResourceLockException e) {
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(e);
            }
        }
        return this.m_lock;
    }

    @Override
    public synchronized void lock() throws ResourceLockException {
        if (this.m_lock) {
            if (this.owner == null || this.owner.getOwner().getName().equals(Thread.currentThread().getName())) {
                String message = null;
                message = this.owner == null ? "jvm lock error owner is null" : "jvm lock error " + this.owner.getOwner() + " is already the owner";
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(message);
                throw new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_FAIL, new Object[]{this.resource, Thread.currentThread().getName()});
            }
            if (!this.owner.isOwnerValid()) {
                this.unlock();
            }
        }
        while (this.m_lock) {
            try {
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("Waiting for a lock on " + this.resource);
                this.wait();
            }
            catch (InterruptedException message) {
            }
            catch (Throwable t) {
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug(t);
                throw new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_FAIL, new Object[]{this.resource, Thread.currentThread().getName()}, t);
            }
        }
        SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("Setting the lock on " + this.resource);
        this.owner = new ThreadLockOwner();
        this.lockDate = new Date();
        this.m_lock = true;
    }

    @Override
    public synchronized void unlock() throws ResourceLockException {
        if (this.m_lock && this.owner != null && this.owner.isOwnerValid() && this.owner.getOwner() != Thread.currentThread()) {
            throw new ResourceLockException(I18NCode.MSG_LOCK_RESOURCE_ALREADY_UNLOCKED, new Object[]{this.resource, this.owner.getOwner().getName()});
        }
        this.m_lock = false;
        this.owner = null;
        this.lockDate = null;
        this.notifyAll();
    }

    @Override
    public synchronized LockOwner getOwner() {
        return this.owner;
    }

    @Override
    public synchronized void setLock(LockProperties lockProperties) {
    }

    @Override
    public synchronized LockProperties getLock() {
        return null;
    }

    @Override
    public String getResource() {
        return this.resource;
    }

    @Override
    public synchronized Date getTimestamp() {
        return this.lockDate;
    }

    @Override
    public synchronized void setTimeStamp(Date start) {
        this.lockDate = start;
    }

    @Override
    public ResourceLockException getError() {
        return this.error;
    }
}

