/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.lock.jvm;

import com.cognos.jsmcommon.lock.LockOwner;
import com.cognos.jsmcommon.lock.ResourceLock;
import com.cognos.jsmcommon.lock.ResourceLockException;
import com.cognos.jsmcommon.lock.ResourceLockFactory;
import com.cognos.jsmcommon.lock.jvm.JvmResourceLock;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.WeakHashMap;

public final class JvmResourceLockFactory
implements ResourceLockFactory {
    private static JvmResourceLockFactory instance = new JvmResourceLockFactory();
    private WeakHashMap<String, JvmResourceLock> locks = new WeakHashMap();

    public static JvmResourceLockFactory instance() {
        return instance;
    }

    @Override
    public synchronized ResourceLock getLock(String resource) {
        SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("getting JvmresourceLock for " + resource);
        if (!this.locks.containsKey(resource)) {
            this.locks.put(resource, new JvmResourceLock(resource));
        }
        return this.locks.get(resource);
    }

    @Override
    public synchronized ResourceLock getLock(String resource, LockOwner owner) {
        return this.getLock(resource);
    }

    public synchronized int countLocks() {
        int lockCount = 0;
        for (ResourceLock resourceLock : this.locks.values()) {
            if (!resourceLock.isLocked()) continue;
            ++lockCount;
        }
        return lockCount;
    }

    public synchronized void breakLocksForOwner(LockOwner owner) throws ResourceLockException {
        SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("breaking JvmresourceLock for owner" + owner);
        ArrayList<String> toRemove = new ArrayList<String>();
        for (ResourceLock resourceLock : this.locks.values()) {
            if (!resourceLock.getOwner().getName().equals(owner.getName())) continue;
            toRemove.add(resourceLock.getResource());
        }
        for (String string : toRemove) {
            this.locks.remove(string);
        }
    }

    private JvmResourceLockFactory() {
    }

    @Override
    public synchronized void stop() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        Iterator<JvmResourceLock> iterator = this.locks.values().iterator();
        while (iterator.hasNext()) {
            ResourceLock lock;
            ResourceLock resourceLock = lock = (ResourceLock)iterator.next();
            synchronized (resourceLock) {
                lock.notify();
            }
        }
        this.locks.clear();
    }

    @Override
    public synchronized void start() {
    }
}

