/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.logging;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.BoundRangeParmValueItem;
import com.cognos.developer.schemas.bibus._3.HierarchicalParmValueItem;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.cognos.developer.schemas.bibus._3.UnboundedEndRangeParmValueItem;
import com.cognos.developer.schemas.bibus._3.UnboundedStartRangeParmValueItem;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.jsmcommon.logging.IJobLogger;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.jsmcommon.version.BuildComposite;
import com.cognos.jsmcommon.version.IVersionInfo;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.dom4j.io.OutputFormat;

public class JobServiceLogUtil
implements IJobLogger {
    private LogTypedLogger _logger;
    private int _build;

    public JobServiceLogUtil(LogTypedLogger logger, IVersionInfo version) {
        this._logger = logger;
        this._build = version.getBuildComposite(BuildComposite.MAJOR_VERSION);
    }

    @Override
    public void logJobSubmit(TaskID id, String path, BiBusHeader header, ParameterValue[] parameters, Option[] options) {
        try {
            if (this._logger.isEnabled(30000)) {
                LogAuditAccessIndication indication = this.newIndication();
                this.buildIndication(indication, header, path, id);
                indication.setObjectType("JobDefinition");
                indication.setLogData(this.getParameterString(parameters, options));
                this._logger.log((Object)indication);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void logJobEnd(TaskID id, String path, BiBusHeader header, TaskStatus taskStatus, String error) {
        try {
            if (this._logger.isEnabled(30000)) {
                LogAuditAccessIndication indication = this.newIndication();
                this.buildIndication(indication, header, path, id);
                indication.setObjectType("JobDefinition");
                if (taskStatus == TaskStatus.FAILED) {
                    indication.setErrorMessage(error);
                    indication.setStatus("Failure");
                } else {
                    indication.setStatus("Success");
                }
                this._logger.log((Object)indication);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void logStepStart(TaskID id, TaskID parent, String path, BiBusHeader header, ParameterValue[] parameters, Option[] options) {
        try {
            if (this._logger.isEnabled(30000)) {
                LogAuditAccessIndication indication = this.newIndication();
                this.buildIndication(indication, header, path, id);
                indication.setObjectType("JobStepDefinition");
                indication.setLogData(this.getParameterString(parameters, options));
                indication.setSubRequestID(parent.toEventId());
                this._logger.log((Object)indication);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void logStepEnd(TaskID id, TaskID parent, String path, BiBusHeader header, TaskStatus taskStatus, String error) {
        try {
            if (this._logger.isEnabled(30000)) {
                LogAuditAccessIndication indication = this.newIndication();
                this.buildIndication(indication, header, path, id);
                indication.setObjectType("JobStepDefinition");
                indication.setSubRequestID(parent.toEventId());
                if (taskStatus == TaskStatus.FAILED) {
                    indication.setErrorMessage(error);
                    indication.setStatus("Failure");
                } else {
                    indication.setStatus("Success");
                }
                this._logger.log((Object)indication);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    LogAuditAccessIndication newIndication() {
        return new LogAuditAccessIndication("JS", this._build);
    }

    void buildIndication(LogAuditAccessIndication indication, BiBusHeader header, String path, TaskID id) {
        indication.setLevel(30000);
        indication.setObjectPath(path);
        indication.setOperation("Submit");
        indication.setStepID(id.toEventId());
        Tracking tracking = header.getTracking();
        if (tracking != null) {
            String sessionContext = tracking.getSessionContext();
            indication.setSessionID(sessionContext);
            String requestContext = tracking.getRequestContext();
            indication.setRequestID(requestContext);
        }
    }

    private String getParameterString(ParameterValue[] parameters, Option[] options) throws UnsupportedEncodingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter outStream = new OutputStreamWriter((OutputStream)out, "UTF-8");
        OutputFormat outFormat = new OutputFormat();
        outFormat.setSuppressDeclaration(true);
        this.writeParameters(outStream, parameters, options);
        return new String(out.toByteArray(), "UTF-8");
    }

    private void writeParameters(OutputStreamWriter outStream, ParameterValue[] parameters, Option[] options) {
        try {
            int idx;
            outStream.write(new String("<parameters>"));
            if (parameters != null && parameters.length > 0) {
                for (idx = 0; idx < parameters.length; ++idx) {
                    outStream.write(new String("<item name='" + parameters[idx].getName() + "'><![CDATA["));
                    ParmValueItem[] params = parameters[idx].getValue();
                    for (int jdx = 0; jdx < params.length; ++jdx) {
                        String value;
                        if (params[jdx] instanceof BoundRangeParmValueItem) {
                            String start = ((BoundRangeParmValueItem)params[jdx]).getStart().getUse();
                            String end = ((BoundRangeParmValueItem)params[jdx]).getEnd().getUse();
                            outStream.write(start + "," + end);
                        }
                        if (params[jdx] instanceof HierarchicalParmValueItem) {
                            value = ((HierarchicalParmValueItem)params[jdx]).getValue().getUse();
                            outStream.write(value);
                        }
                        if (params[jdx] instanceof SimpleParmValueItem) {
                            value = ((SimpleParmValueItem)params[jdx]).getUse();
                            outStream.write(value);
                        }
                        if (params[jdx] instanceof UnboundedEndRangeParmValueItem) {
                            value = ((UnboundedEndRangeParmValueItem)params[jdx]).getStart().getUse();
                            outStream.write(value);
                        }
                        if (!(params[jdx] instanceof UnboundedStartRangeParmValueItem)) continue;
                        value = ((UnboundedStartRangeParmValueItem)params[jdx]).getEnd().getUse();
                        outStream.write(value);
                    }
                    outStream.write("]]></item>");
                }
            }
            if (options != null && options.length > 0) {
                for (idx = 0; idx < options.length; ++idx) {
                    if (options[idx] == null) continue;
                    outStream.write("<item name='" + OptionUtils.getOptionName(options[idx]) + "'><![CDATA[");
                    outStream.write(OptionUtils.getOptionValue(options[idx]) + "]]></item>");
                }
            }
            outStream.write(new String("</parameters>"));
            outStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

