/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.logging;

import com.cognos.jsmcommon.logging.Filter;
import com.cognos.jsmcommon.logging.Formatter;
import com.cognos.jsmcommon.logging.Handler;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class LogManager {
    private static final boolean test = false;
    private static LogManager m_manager;
    private static Map m_loggers;
    private Properties m_properties;
    private Handler[] m_handlers = new Handler[0];

    private LogManager() {
    }

    public static LogManager getLogManager() {
        return m_manager;
    }

    public synchronized void addLogger(SDSLogger logger) {
        SDSCategory sdsCategory = logger.getSDSCategory();
        if (sdsCategory == null) {
            throw new NullPointerException();
        }
        if (m_loggers.containsKey(sdsCategory)) {
            return;
        }
        m_loggers.put(sdsCategory, logger);
    }

    public static synchronized SDSLogger getLogger(SDSCategory sdsCategory) {
        return (SDSLogger)m_loggers.get(sdsCategory);
    }

    public synchronized Set getLoggerCategories() {
        return m_loggers.keySet();
    }

    public String getProperty(String name) {
        return this.m_properties.getProperty(name);
    }

    private void readConfiguration() {
        try {
            InputStream stream = this.getClass().getResourceAsStream("jsmlogging.properties");
            this.m_properties = new Properties();
            this.m_properties.load(stream);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initialiseGlobalHandlers() {
        String[] handlers = this.parseClassNames("handlers");
        for (int i = 0; i < handlers.length; ++i) {
            String handler = handlers[i];
            try {
                Class<?> handler_clazz = Class.forName(handler);
                Handler h = (Handler)handler_clazz.newInstance();
                try {
                    String filter = this.getProperty(handler + ".filter");
                    Class<?> filter_clazz = Class.forName(filter);
                    Filter filt = (Filter)filter_clazz.newInstance();
                    h.setFilter(filt);
                }
                catch (Exception filter) {
                    // empty catch block
                }
                try {
                    String formatter = this.getProperty(handler + ".formatter");
                    Class<?> formatter_clazz = Class.forName(formatter);
                    Formatter frmtr = (Formatter)formatter_clazz.newInstance();
                    h.setFormatter(frmtr);
                }
                catch (Exception formatter) {
                    // empty catch block
                }
                Handler[] newHandlers = new Handler[this.m_handlers.length + 1];
                System.arraycopy(this.m_handlers, 0, newHandlers, 0, this.m_handlers.length);
                newHandlers[this.m_handlers.length] = h;
                this.m_handlers = newHandlers;
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private String[] parseClassNames(String propertyKey) {
        String names = this.getProperty(propertyKey);
        if (names == null) {
            return new String[0];
        }
        names = names.trim();
        int i = 0;
        Vector<String> result = new Vector<String>();
        while (i < names.length()) {
            int end;
            for (end = i; end < names.length() && !Character.isWhitespace(names.charAt(end)) && names.charAt(end) != ','; ++end) {
            }
            String word = names.substring(i, end);
            i = end + 1;
            if ((word = word.trim()).length() == 0) continue;
            result.add(word);
        }
        return result.toArray(new String[result.size()]);
    }

    SDSLevel getLevelProperty(String name, SDSLevel defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return SDSLevel.parse(val.trim());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static Locale getLocale() {
        Locale locale = Locale.getDefault();
        try {
            String localeString = CRNProperties.getInstance().getProperties().getProperty("serverLocale");
            if (null != localeString) {
                int separator_position = Math.max(localeString.indexOf("-"), localeString.indexOf("_"));
                String language = separator_position == -1 ? localeString.trim().toLowerCase() : localeString.substring(0, separator_position).trim().toLowerCase();
                String country = separator_position == -1 ? "" : localeString.substring(separator_position + 1, localeString.length()).trim().toUpperCase();
                locale = LogManager.validCode(language, Locale.getISOLanguages()) && LogManager.validCode(country, Locale.getISOCountries()) ? new Locale(language, country) : null;
                Locale locale2 = locale = locale == null && LogManager.validCode(language, Locale.getISOLanguages()) ? new Locale(language, "") : locale;
                if (null == locale) {
                    locale = Locale.getDefault();
                }
            }
        }
        catch (Exception e) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public Handler[] getHandlers() {
        return this.m_handlers;
    }

    private static boolean validCode(String code, String[] choices) {
        boolean found = false;
        for (int i = 0; i < choices.length && !found; ++i) {
            if (!choices[i].equalsIgnoreCase(code)) continue;
            found = true;
        }
        return found;
    }

    static {
        m_loggers = new Hashtable();
        m_manager = new LogManager();
        m_manager.readConfiguration();
        m_manager.initialiseGlobalHandlers();
    }
}

