/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.logging;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import java.io.Serializable;
import java.util.Map;

public class LogRecord
implements Serializable {
    private SDSLevel m_level;
    private final I18NCode m_code;
    private Object[] m_parameters;
    private SDSCategory m_SDSCategory;
    private long m_millis;
    private String m_sourceClass;
    private String m_sourceMethod;
    private boolean m_inferCaller;
    private int m_build_number;
    private Map m_props;

    protected LogRecord(SDSLevel level, I18NCode code, int build) {
        this.m_build_number = build;
        this.m_level = level;
        this.m_code = code;
        this.m_millis = System.currentTimeMillis();
        this.m_inferCaller = true;
    }

    public I18NCode getI18NCode() {
        return this.m_code;
    }

    public SDSLevel getLevel() {
        return this.m_level;
    }

    void setLevel(SDSLevel level) {
        this.m_level = level;
    }

    public Object[] getParameters() {
        return this.m_parameters;
    }

    public void setParameters(Object[] parameters) {
        this.m_parameters = parameters;
        int j = this.m_parameters.length;
        for (int i = 0; i < j; ++i) {
            if (null != this.m_parameters[i]) continue;
            this.m_parameters[i] = "";
        }
    }

    public long getMillis() {
        return this.m_millis;
    }

    public int getBuildNumber() {
        return this.m_build_number;
    }

    public void setSourceClass(String sourceClass) {
        this.m_sourceClass = sourceClass;
        this.m_inferCaller = false;
    }

    public String getSourceClass() {
        if (this.m_inferCaller) {
            this.inferCaller();
        }
        return this.m_sourceClass;
    }

    public void setSourceMethod(String sourceMethod) {
        this.m_sourceMethod = sourceMethod;
        this.m_inferCaller = false;
    }

    public String getSourceMethod() {
        if (this.m_inferCaller) {
            this.inferCaller();
        }
        return this.m_sourceMethod;
    }

    public void setSDSCategory(SDSCategory sdsCategory) {
        this.m_SDSCategory = sdsCategory;
    }

    public SDSCategory getSDSCategory() {
        return this.m_SDSCategory;
    }

    public void setProperties(Map props) {
        this.m_props = props;
    }

    public Map getProperties() {
        return this.m_props;
    }

    public Object getProperty(Object key) {
        return this.m_props != null ? this.m_props.get(key) : null;
    }

    private void inferCaller() {
    }
}

