/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.logging;

import com.cognos.indications.LogPerfIndication;
import com.cognos.indications.LogResourceCounterSet;
import com.cognos.indications.LogTypedLogger;
import com.cognos.jsmcommon.logging.IPerfLog;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.util.ThreadProperties;
import com.cognos.jsmcommon.version.BuildComposite;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class PerfLog
implements IPerfLog {
    public static final String _ENTER = "ENTER";
    private static final String _EXIT = "EXIT";
    public static final String _BEGIN = "BEGIN";
    private static final String _FINISH = "FINISH";
    public static final String _CALL = "CALL";
    private static final String _RETURN = "RETURN";
    private LogTypedLogger m_logger;
    private int m_build_num;
    private Class m_class;
    private LogPerfIndication m_pind = null;
    private SDSCategory m_category;
    private int m_stack_count = 3;
    private boolean m_started = false;
    private boolean m_stopped = false;
    private String m_logData;

    PerfLog(SDSCategory category, Class clazz) {
        String perf = category.getCategoryName() + "." + clazz.getPackage().getName();
        this.m_category = category;
        this.m_logger = LogTypedLogger.getInstance((String)perf, LogPerfIndication.class);
        this.m_build_num = category.getVersionInfo().getBuildComposite(BuildComposite.MAJOR_VERSION);
        this.m_class = clazz;
    }

    @Override
    public void setLogData(String logData) {
        if (this.m_pind != null) {
            this.m_pind.setLogData(logData);
        } else {
            this.m_logData = logData;
        }
    }

    @Override
    public void stop() {
        if (!this.m_started || this.m_stopped) {
            return;
        }
        if (this.m_pind != null && this.m_logger.isEnabled(this.m_pind.getLevel())) {
            if (this.m_pind.getRCS() != null) {
                this.m_pind.getRCS().disableResourceCounter();
            }
            this.m_pind.setStatus(this.getClosingStatus(this.m_pind.getStatus()));
            this.m_logger.log((Object)this.m_pind);
            this.m_stopped = true;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.m_started && !this.m_stopped && this.m_pind != null && this.m_logger.isEnabled(this.m_pind.getLevel())) {
            this.m_pind.setLogData("PerfIndication stopped by finalize().  Performance data could be incorrect. Please check PerfIndication usage.");
            this.stop();
        }
    }

    void start(SDSLevel level, String status) {
        ++this.m_stack_count;
        this.start(level, status, "");
    }

    void start(SDSLevel level, String status, String sequence_id) {
        if (!this.valid(level, status)) {
            return;
        }
        if (this.m_logger.isEnabled(level.intValue())) {
            String method = this.getCaller(this.m_stack_count);
            LogResourceCounterSet ctrset = new LogResourceCounterSet("Execution", null);
            this.m_pind = new LogPerfIndication(this.m_category.getComponentName(), this.m_build_num, ctrset);
            this.m_pind.setLevel(level.intValue());
            this.m_pind.setClassId(this.m_class.getName());
            this.m_pind.setMethodId(method);
            this.m_pind.setStatus(status);
            this.m_pind.setSequenceId(sequence_id);
            this.m_pind.setRequestID(ThreadProperties.getProperty("request_id_key"));
            this.m_pind.setSessionID(ThreadProperties.getProperty("session_id_key"));
            if (this.m_logData != null) {
                this.m_pind.setLogData(this.m_logData);
            }
            ctrset.enableResourceCounter();
            this.m_logger.log((Object)this.m_pind);
            this.m_started = true;
        }
    }

    private String getClosingStatus(String open_status) {
        String status = "";
        if (_CALL.equals(open_status)) {
            status = _RETURN;
        } else if (_ENTER.equals(open_status)) {
            status = _EXIT;
        } else if (_BEGIN.equals(open_status)) {
            status = _FINISH;
        }
        return status;
    }

    private String getCaller(int callerNumber) {
        if (callerNumber < 1) {
            return "Trace";
        }
        int tokenNumber = callerNumber * 2 + 3;
        CharArrayWriter stream = new CharArrayWriter();
        Throwable throwable = new Throwable();
        throwable.printStackTrace(new PrintWriter(stream));
        StringTokenizer stackTrace = new StringTokenizer(stream.toString());
        String token = "";
        try {
            for (int i = 0; i < tokenNumber; ++i) {
                token = stackTrace.nextToken();
            }
        }
        catch (NoSuchElementException ignored) {
            token = "unknown";
        }
        String pakage = this.m_class.getName() + ".";
        int index = token.indexOf(pakage);
        if (index != -1) {
            token = token.substring(index + pakage.length());
        }
        return token;
    }

    private boolean valid(SDSLevel level, String status) {
        boolean valid = this.getClass().getName().equals(this.m_class.getName());
        valid = !this.m_started;
        valid = valid && status != null && (_BEGIN.equals(status) || _ENTER.equals(status) || _CALL.equals(status));
        return valid;
    }
}

