/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.logging;

import com.cognos.jsmcommon.version.BuildComposite;
import com.cognos.jsmcommon.version.IVersionInfo;
import java.io.Serializable;
import java.util.jar.Attributes;

public abstract class SDSCategory
implements Serializable {
    protected static final String _AUDIT = "Audit";
    protected static final String _TRACE = "Trace";
    protected static final String _PERF = "Perf";
    protected static final String _RUNTIME = "Audit.RTUsage";
    private String m_name;
    private String m_component;
    private IVersionInfo m_versionInfo;

    protected SDSCategory(String name, IVersionInfo versionInfo) {
        if (versionInfo != null) {
            this.m_component = versionInfo.getManifestValue(Attributes.Name.IMPLEMENTATION_TITLE);
            this.m_name = name + "." + this.m_component;
        } else {
            this.m_component = "";
            this.m_name = "";
        }
        this.m_versionInfo = versionInfo;
    }

    protected SDSCategory(String name, String subComponent, IVersionInfo versionInfo) {
        if (versionInfo != null) {
            this.m_component = versionInfo.getManifestValue(Attributes.Name.IMPLEMENTATION_TITLE);
            this.m_name = name + "." + this.m_component + "." + subComponent;
        } else {
            this.m_component = "";
            this.m_name = "";
        }
        this.m_versionInfo = versionInfo;
    }

    public String getCategoryName() {
        return this.m_name;
    }

    public String getComponentName() {
        return this.m_component;
    }

    public int getComponentBuildNumber() {
        if (this.m_versionInfo != null) {
            return this.m_versionInfo.getBuildComposite(BuildComposite.MAJOR_VERSION);
        }
        return 0;
    }

    public IVersionInfo getVersionInfo() {
        return this.m_versionInfo;
    }

    public String toString() {
        return this.m_name;
    }
}

