/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.logging;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SDSLevel
implements Serializable {
    private final String m_name;
    private final int m_value;
    private static List m_known = new ArrayList();
    public static final SDSLevel OFF = new SDSLevel("OFF", Integer.MAX_VALUE);
    public static final SDSLevel FATAL = new SDSLevel("FATAL", 50000);
    public static final SDSLevel ERROR = new SDSLevel("ERROR", 40000);
    public static final SDSLevel WARN = new SDSLevel("WARN", 30000);
    public static final SDSLevel INFO = new SDSLevel("INFO", 20000);
    public static final SDSLevel DEBUG = new SDSLevel("DEBUG", 10000);
    public static final SDSLevel ALL = new SDSLevel("ALL", Integer.MIN_VALUE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SDSLevel(String name, int value) {
        this.m_name = name;
        this.m_value = value;
        Class<SDSLevel> clazz = SDSLevel.class;
        synchronized (SDSLevel.class) {
            m_known.add(this);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public final int intValue() {
        return this.m_value;
    }

    public static synchronized SDSLevel parse(String name) throws IllegalArgumentException {
        name.length();
        SDSLevel level = null;
        boolean found = false;
        for (int i = 0; !found && i < m_known.size(); ++i) {
            SDSLevel lvl = (SDSLevel)m_known.get(i);
            if (!name.equals(lvl.m_name)) continue;
            level = lvl;
            found = true;
        }
        if (!found) {
            try {
                int x = Integer.parseInt(name);
                for (int i = 0; !found && i < m_known.size(); ++i) {
                    SDSLevel lvl = (SDSLevel)m_known.get(i);
                    if (lvl.m_value != x) continue;
                    level = lvl;
                    found = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!found) {
            throw new IllegalArgumentException("Invalid level \"" + name + "\"");
        }
        return level;
    }

    public boolean equals(Object obj) {
        try {
            SDSLevel lx = (SDSLevel)obj;
            return lx.m_value == this.m_value;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public int hashCode() {
        return this.m_value;
    }

    public String toString() {
        return this.m_name;
    }
}

