/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.logging;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.Handler;
import com.cognos.jsmcommon.logging.ISDSLogger;
import com.cognos.jsmcommon.logging.LogManager;
import com.cognos.jsmcommon.logging.LogRecord;
import com.cognos.jsmcommon.logging.PerfLog;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLoggingUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import java.util.Locale;
import java.util.Map;

public class SDSLogger
implements ISDSLogger {
    private SDSCategory m_SDSCategory;
    private static Locale m_locale = Locale.getDefault();
    private int m_buildnum;
    private static SDSLogger logger;
    private static final String sLog = "SDSLogger.";

    protected SDSLogger(SDSCategory sdsCategory) {
        this.m_SDSCategory = sdsCategory;
        this.m_buildnum = this.m_SDSCategory.getComponentBuildNumber();
        m_locale = LogManager.getLocale();
    }

    public static void _setLogger(SDSLogger aLogger) {
        logger = aLogger;
    }

    public static synchronized SDSLogger getLogger(SDSCategory sdsCategory) {
        if (logger != null) {
            return logger;
        }
        LogManager manager = LogManager.getLogManager();
        SDSLogger logger = LogManager.getLogger(sdsCategory);
        if (logger == null) {
            logger = new SDSLogger(sdsCategory);
            manager.addLogger(logger);
            logger = LogManager.getLogger(sdsCategory);
        }
        return logger;
    }

    @Override
    public Handler[] getHandlers() {
        return LogManager.getLogManager().getHandlers();
    }

    protected SDSCategory getSDSCategory() {
        return this.m_SDSCategory;
    }

    @Override
    public void log(LogRecord record) {
        Handler[] targets = this.getHandlers();
        if (targets != null) {
            for (int i = 0; i < targets.length; ++i) {
                targets[i].publish(record);
            }
        }
    }

    @Override
    public void log(SDSLevel level, I18NCode code) {
        this.log(this.newRecord(level, code));
    }

    @Override
    public boolean isLoggingAt(SDSLevel level) {
        boolean bRet = false;
        Handler[] targets = this.getHandlers();
        if (targets != null && !bRet) {
            for (int i = 0; i < targets.length && !bRet; ++i) {
                bRet = targets[i].isLoggingAt(this.m_SDSCategory, level);
            }
        }
        return bRet;
    }

    @Override
    public void log(SDSLevel level, I18NCode code, Object[] params) {
        LogRecord record = this.newRecord(level, code);
        record.setParameters(params);
        this.log(record);
    }

    @Override
    public void log(SDSLevel level, I18NCode code, Map props) {
        LogRecord record = this.newRecord(level, code);
        record.setProperties(props);
        this.log(record);
    }

    @Override
    public void log(SDSLevel level, I18NCode code, Object[] params, Map props) {
        LogRecord record = this.newRecord(level, code);
        record.setParameters(params);
        record.setProperties(props);
        this.log(record);
    }

    @Override
    public void log(SDSLevel level, Throwable e) {
        SDSLoggingUtil.log(this, e);
    }

    @Override
    public void log(SDSLevel level, LocalizableException e) {
        this.log(level, e.getI18NCode(), e.getParams());
    }

    @Override
    public void log(SDSLevel level, Map props) {
        LogRecord record = this.newRecord(level, null);
        record.setProperties(props);
        this.log(record);
    }

    @Override
    public void startService(String service, String status) {
        this.startService(service, status, "");
    }

    @Override
    public void startService(String service, String status, String msg) {
        AuditProperties props = new AuditProperties("StartService", msg, service, status);
        this.log(SDSLevel.FATAL, props);
    }

    @Override
    public void stopService(String service, String status) {
        this.stopService(service, status, "");
    }

    @Override
    public void stopService(String service, String status, String msg) {
        AuditProperties props = new AuditProperties("StopService", msg, service, status);
        this.log(SDSLevel.FATAL, props);
    }

    @Override
    public PerfLog start(Class clazz, SDSLevel level, String status) {
        PerfLog perf_log = new PerfLog(this.getSDSCategory(), clazz);
        perf_log.start(level, status);
        return perf_log;
    }

    @Override
    public PerfLog start(Class clazz, SDSLevel level, String status, String sequence_id) {
        PerfLog perf_log = new PerfLog(this.getSDSCategory(), clazz);
        perf_log.start(level, status, sequence_id);
        return perf_log;
    }

    @Override
    public PerfLog start(Class clazz, SDSLevel level, String status, String sequence_id, String logData) {
        PerfLog perf_log = new PerfLog(this.getSDSCategory(), clazz);
        perf_log.setLogData(logData);
        perf_log.start(level, status, sequence_id);
        return perf_log;
    }

    @Override
    public void debug(Throwable t) {
        if (t != null) {
            SDSLoggingUtil.debug(this, t);
        } else {
            String message = "null Throwable sent to debug log method.";
            this.log(SDSLevel.DEBUG, null, new Object[]{message});
        }
    }

    public void debug(Throwable t, boolean alwaysIncludeStackTrace) {
        if (t != null) {
            SDSLoggingUtil.debug(this, t, alwaysIncludeStackTrace);
        } else {
            String message = "null Throwable sent to debug log method.";
            this.log(SDSLevel.DEBUG, null, new Object[]{message});
        }
    }

    @Override
    public void debug(Object o, String debug) {
        this.log(SDSLevel.DEBUG, null, new Object[]{o.getClass().getName(), ": ", debug});
    }

    @Override
    public void debug(String debug) {
        debug = debug != null ? debug : "null debug message sent to debug log method.";
        this.log(SDSLevel.DEBUG, null, new Object[]{debug});
    }

    public void error(String errMsg) {
        errMsg = errMsg != null ? errMsg : "null error message sent to error log method.";
        this.log(SDSLevel.ERROR, null, new Object[]{errMsg});
    }

    @Override
    public void debug(String debug, Map props) {
        debug = debug != null ? debug : "null debug message sent to debug log method.";
        this.log(SDSLevel.DEBUG, null, new Object[]{debug}, props);
    }

    private LogRecord newRecord(SDSLevel level, I18NCode code) {
        LogRecord record = new LogRecord(level, code, this.m_buildnum);
        record.setSDSCategory(this.m_SDSCategory);
        return record;
    }

    @Override
    public String toString() {
        return sLog + this.getSDSCategory().toString();
    }

    public static Locale getLocale() {
        return m_locale;
    }
}

