/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.logging;

import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.logging.util.IPFMessage;

public class SDSLoggingUtil {
    private SDSLoggingUtil() {
    }

    static void debug(SDSLogger logger, Throwable e) {
        SDSLoggingUtil.debug(logger, e, false);
    }

    static void debug(SDSLogger logger, Throwable e, boolean alwaysIncludeStackTrace) {
        if (logger.isLoggingAt(SDSLevel.DEBUG) || logger.isLoggingAt(SDSLevel.INFO)) {
            IPFMessage ipfMessage = new IPFMessage();
            SDSLoggingUtil.addMessages(ipfMessage, e, true, alwaysIncludeStackTrace);
            String errorMessage = ipfMessage.toIPFTrace();
            logger.debug(errorMessage);
        }
    }

    static void log(SDSLogger logger, Throwable e) {
        IPFMessage ipfMessage = new IPFMessage();
        SDSLoggingUtil.addMessages(ipfMessage, e, false, false);
        String errorMessage = ipfMessage.toIPFMessage();
        logger.log(SDSLevel.ERROR, null, new Object[]{errorMessage});
    }

    private static void addMessages(IPFMessage ipfMessage, Throwable e, boolean allMessages, boolean alwaysIncludeStackTraces) {
        ipfMessage.addMessage(e.getLocalizedMessage());
        if (!(e instanceof LocalizableException)) {
            if ((alwaysIncludeStackTraces || e instanceof RuntimeException) && allMessages) {
                SDSLoggingUtil.addStack(ipfMessage, e);
            }
            return;
        }
        Throwable nested = ((LocalizableException)e).getNested();
        while (nested != null) {
            if (nested instanceof LocalizableException) {
                ipfMessage.addMessage(nested.getLocalizedMessage());
                nested = ((LocalizableException)nested).getNested();
                continue;
            }
            if (!allMessages) break;
            ipfMessage.addMessage(nested.getLocalizedMessage());
            if (!alwaysIncludeStackTraces && !(nested instanceof RuntimeException)) break;
            SDSLoggingUtil.addStack(ipfMessage, nested);
            break;
        }
    }

    private static void addStack(IPFMessage ipfMessage, Throwable e) {
        ipfMessage.addStack(e);
        Throwable nested = null;
        if (e instanceof LocalizableException) {
            nested = ((LocalizableException)e).getNested();
        }
        while (nested != null) {
            ipfMessage.addStack(nested);
            if (!(e instanceof LocalizableException)) continue;
            nested = ((LocalizableException)e).getNested();
        }
    }
}

