/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.logging.ipf;

import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogIndication;
import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.jsmcommon.logging.Handler;
import com.cognos.jsmcommon.logging.LogRecord;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.util.ThreadProperties;

public class IPFHandler
extends Handler {
    @Override
    public void publish(LogRecord record) {
        if (record == null || !this.isLoggable(record)) {
            return;
        }
        if (record.getSDSCategory().getCategoryName().startsWith("Audit.")) {
            this.audit(record);
        } else {
            this.trace(record);
        }
    }

    private void populateCommon(LogRecord record, LogIndication indication) {
        indication.setLevel(IPFHandler.getIPFLevel(record.getLevel()));
        indication.setRequestID(ThreadProperties.getProperty("request_id_key") != null ? ThreadProperties.getProperty("request_id_key") : "");
        indication.setSessionID(ThreadProperties.getProperty("session_id_key") != null ? ThreadProperties.getProperty("session_id_key") : "");
        indication.setStepID(ThreadProperties.getProperty("step_id_key") != null ? ThreadProperties.getProperty("step_id_key") : "");
        indication.setSubRequestID(ThreadProperties.getProperty("hop_id_key") != null ? ThreadProperties.getProperty("hop_id_key") : "");
    }

    private void audit(LogRecord record) {
        int i = record.getLevel().intValue();
        if (i > SDSLevel.INFO.intValue()) {
            LogAuditAccessIndication indication = new LogAuditAccessIndication(record.getSDSCategory().getComponentName(), record.getBuildNumber());
            this.populateCommon(record, (LogIndication)indication);
            indication.setErrorMessage(this.getFormatter().format(record));
            indication.setOperation(record.getProperty("operation_key") != null ? (String)record.getProperty("operation_key") : "");
            indication.setObjectPath(record.getProperty("object_path_key") != null ? (String)record.getProperty("object_path_key") : "");
            indication.setObjectType(record.getProperty("object_type_key") != null ? (String)record.getProperty("object_type_key") : "");
            indication.setStatus(record.getProperty("status_key") != null ? (String)record.getProperty("status_key") : "");
            LogTypedLogger logger = LogTypedLogger.getInstance((String)record.getSDSCategory().getCategoryName(), LogAuditAccessIndication.class);
            logger.log((Object)indication);
        } else {
            LogAuditIndication indication = new LogAuditIndication(record.getSDSCategory().getComponentName(), record.getBuildNumber());
            this.populateCommon(record, (LogIndication)indication);
            indication.setLogData(this.getFormatter().format(record));
            LogTypedLogger logger = LogTypedLogger.getInstance((String)record.getSDSCategory().getCategoryName(), indication.getClass());
            logger.log((Object)indication);
        }
    }

    private void trace(LogRecord record) {
        LogTraceIndication indication = new LogTraceIndication(record.getSDSCategory().getComponentName(), record.getBuildNumber());
        this.populateCommon(record, (LogIndication)indication);
        indication.setAction((byte)11);
        indication.setMessage(this.getFormatter().format(record));
        indication.setObject(record.getSDSCategory().getComponentName());
        LogTypedLogger logger = LogTypedLogger.getInstance((String)record.getSDSCategory().getCategoryName(), indication.getClass());
        logger.log((Object)indication);
    }

    public static int getIPFLevel(SDSLevel level) {
        if (level.equals(SDSLevel.OFF)) {
            return Integer.MAX_VALUE;
        }
        if (level.equals(SDSLevel.FATAL)) {
            return 50000;
        }
        if (level.equals(SDSLevel.ERROR)) {
            return 40000;
        }
        if (level.equals(SDSLevel.WARN)) {
            return 30000;
        }
        if (level.equals(SDSLevel.INFO)) {
            return 20000;
        }
        if (level.equals(SDSLevel.DEBUG)) {
            return 20000;
        }
        if (level.equals(SDSLevel.ALL)) {
            return Integer.MIN_VALUE;
        }
        return Integer.MIN_VALUE;
    }
}

