/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.logging.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IPFMessage {
    private static final String START_MESSAGES = "<messages><message><messageString>";
    private static final String END_START_MESSAGE = "</messageString></message><message><messageString>";
    private static final String END_MESSAGES = "</messageString></message></messages>";
    private List messages = new ArrayList();

    public static String stackToIPFMessage(Throwable e) {
        StringWriter sw = new StringWriter(1024);
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        String stack = sw.toString();
        BufferedReader br = new BufferedReader(new StringReader(stack));
        StringBuffer buffer = new StringBuffer(START_MESSAGES);
        try {
            String stackLine = br.readLine();
            buffer.append(stackLine);
            while (null != (stackLine = br.readLine())) {
                buffer.append(END_START_MESSAGE);
                buffer.append(stackLine);
            }
            buffer.append(END_MESSAGES);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buffer.toString();
    }

    public void addMessage(String messageString) {
        if (messageString != null) {
            this.messages.add(messageString);
        }
    }

    public void addMessages(String[] messageStrings) {
        for (int i = 0; i < messageStrings.length; ++i) {
            if (messageStrings[i] == null) continue;
            this.messages.add(messageStrings[i]);
        }
    }

    public void addStack(Throwable e) {
        StringWriter sw = new StringWriter(1024);
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        String stack = sw.toString();
        BufferedReader br = new BufferedReader(new StringReader(stack));
        try {
            String stackLine = null;
            while (null != (stackLine = br.readLine())) {
                this.messages.add(stackLine);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toIPFMessage() {
        Iterator iter = this.messages.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(START_MESSAGES);
        buffer.append((String)iter.next());
        while (iter.hasNext()) {
            buffer.append(END_START_MESSAGE);
            buffer.append((String)iter.next());
        }
        buffer.append(END_MESSAGES);
        return buffer.toString();
    }

    public String toIPFTrace() {
        Iterator iter = this.messages.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer("<trace>");
        buffer.append((String)iter.next());
        while (iter.hasNext()) {
            buffer.append((String)iter.next());
        }
        buffer.append("</trace>");
        return buffer.toString();
    }

    public String toIPFLogDataMessage() {
        return "<trace>" + this.toIPFMessage() + "</trace>";
    }
}

