/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.mailUtils;

import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;

public class MailUtil {
    private static final String PROTOCOL_SMTP = "smtp";
    private static final String PROTOCOL_SMTPS = "smtps";
    public static final String MAIL_SMTP_STARTTLS_REQUIRED = "mail.smtp.starttls.required";
    public static final String MAIL_SMTP_STARTTLS_ENABLE = "mail.smtp.starttls.enable";
    public static final String SUPPORTED_SSL_PROTOCOLS_LIST = "SSLv3 TLSv1 TLSv1.1 TLSv1.2";

    public static String getMailProtocol() {
        String strProtocol = PROTOCOL_SMTP;
        try {
            if (MailUtil.isSmtpsEncryptionEnabled()) {
                strProtocol = MailUtil.getTlsEnabled() ? PROTOCOL_SMTP : PROTOCOL_SMTPS;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strProtocol;
    }

    public static String getMailProtocol(CRNProperties crnp) {
        String strProtocol = PROTOCOL_SMTP;
        try {
            if (MailUtil.isSmtpsEncryptionEnabled(crnp)) {
                strProtocol = MailUtil.getTlsEnabled(crnp) ? PROTOCOL_SMTP : PROTOCOL_SMTPS;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strProtocol;
    }

    public static boolean isSmtpsEncryptionEnabled() {
        String sslEncryptionEnabled = null;
        boolean isSslEncryptionEnabled = false;
        try {
            sslEncryptionEnabled = MailUtil.getProperty("SSLencryptionEnabled");
            if (sslEncryptionEnabled != null && sslEncryptionEnabled.trim().equalsIgnoreCase("true")) {
                isSslEncryptionEnabled = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isSslEncryptionEnabled;
    }

    private static boolean getTlsEnabled() {
        String tlsEncryptionEnabled = null;
        boolean isTlsEncryptionEnabled = false;
        try {
            tlsEncryptionEnabled = MailUtil.getProperty("emf.mail.tls.enabled");
            if (tlsEncryptionEnabled != null && tlsEncryptionEnabled.trim().equalsIgnoreCase("true")) {
                isTlsEncryptionEnabled = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isTlsEncryptionEnabled;
    }

    public static boolean isTlsEnabled() {
        boolean enableTls = false;
        try {
            enableTls = MailUtil.getTlsEnabled();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return enableTls;
    }

    private static String getProperty(String propertyName) {
        String propertyValue = "";
        try {
            propertyValue = CRNProperties.getInstance().getProperty(propertyName);
            if (propertyValue != null) {
                propertyValue = propertyValue.trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return propertyValue;
    }

    public static boolean isSmtpsEncryptionEnabled(CRNProperties crnp) {
        String SSLencryptionEnabled = null;
        boolean smtpsEncryptionEnabled = false;
        try {
            if (crnp != null && (SSLencryptionEnabled = crnp.getProperty("SSLencryptionEnabled")) != null && SSLencryptionEnabled.equalsIgnoreCase("true")) {
                smtpsEncryptionEnabled = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return smtpsEncryptionEnabled;
    }

    public static boolean getTlsEnabled(CRNProperties crnp) {
        String strTlsEnabled = null;
        boolean isTlsEnabled = false;
        try {
            if (crnp != null && (strTlsEnabled = crnp.getProperty("emf.mail.tls.enabled")) != null && strTlsEnabled.equalsIgnoreCase("true")) {
                isTlsEnabled = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isTlsEnabled;
    }

    public static boolean isTlsEnabled(CRNProperties crnp) {
        boolean enableTls = false;
        try {
            enableTls = MailUtil.getTlsEnabled(crnp);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return enableTls;
    }

    public static String getSMTP_SSL_Protocols(CRNProperties crnp) {
        String result = null;
        try {
            result = crnp.getProperty("mail.smtp.ssl.protocols");
        }
        catch (PropertiesException propertiesException) {
            // empty catch block
        }
        return result;
    }

    public static String getSMTP_SSL_Protocols() {
        String result = null;
        try {
            result = CRNProperties.getInstance().getProperty("mail.smtp.ssl.protocols");
        }
        catch (PropertiesException propertiesException) {
            // empty catch block
        }
        return result;
    }
}

